package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 拜访步骤(活动执行);
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepactivity")
@Api(tags = "拜访步骤(活动执行);")
public class SfaVisitStepActivityController {
    @Resource
    private ISfaVisitStepActivityService sfaVisitStepActivityService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitStepActivityRespVo>> list(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        PageResult<SfaVisitStepActivityRespVo> result=sfaVisitStepActivityService.findList(sfaVisitStepActivityReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaVisitStepActivityRespVo> query(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        SfaVisitStepActivityRespVo respVo=sfaVisitStepActivityService.query(sfaVisitStepActivityReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        sfaVisitStepActivityService.save(sfaVisitStepActivityReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @CrmAPIDiscard
    public Result update(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        sfaVisitStepActivityService.update(sfaVisitStepActivityReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @CrmAPIDiscard
    public Result delete(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        sfaVisitStepActivityService.deleteBatch(sfaVisitStepActivityReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        sfaVisitStepActivityService.enableBatch(sfaVisitStepActivityReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody  SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
        sfaVisitStepActivityService.disableBatch(sfaVisitStepActivityReqVo);
        return Result.ok("禁用成功");
    }
}
