package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.req.GetCompleteActivityTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCostActivityTableRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreDisplayActivityTableRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 活动执行;
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitStepActivityExecutionController")
@Api(tags = "拜访步骤(活动执行;)")
public class SfaVisitStepActivityExecutionController {
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private SfaVisitStepActivityExecutionServiceEsImpl sfaVisitStepActivityExecutionServiceEs;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitStepActivityExecutionRespVo>> list(@RequestBody SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        PageResult<SfaVisitStepActivityExecutionRespVo> result=sfaVisitStepActivityExecutionService.findList(sfaVisitStepActivityExecutionReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitStepActivityExecutionRespVo> query(@RequestBody SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        SfaVisitStepActivityExecutionRespVo respVo=sfaVisitStepActivityExecutionService.query(sfaVisitStepActivityExecutionReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        sfaVisitStepActivityExecutionService.save(sfaVisitStepActivityExecutionReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        sfaVisitStepActivityExecutionService.update(sfaVisitStepActivityExecutionReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        sfaVisitStepActivityExecutionService.deleteBatch(sfaVisitStepActivityExecutionReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        sfaVisitStepActivityExecutionService.enableBatch(sfaVisitStepActivityExecutionReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo) {
        sfaVisitStepActivityExecutionService.disableBatch(sfaVisitStepActivityExecutionReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 费用活动执行报表
     */
    @ApiOperation(value = "费用活动执行报表")
    @PostMapping("/findVisitStepCostActivityExecutionEsList")
    @CrmLog
    public Result<PageResult<SfaVisitStepStoreCostActivityTableRespVo>> findVisitStepCostActivityExecutionEsList(@RequestBody GetCompleteActivityTablePageReq req) {
        PageResult<SfaVisitStepStoreCostActivityTableRespVo> result = sfaVisitStepActivityExecutionServiceEs.findVisitStepCostActivityExecutionEsList(req);
        return Result.ok(result);
    }

    /**
     * 陈列活动执行报表
     */
    @ApiOperation(value = "陈列活动执行报表")
    @PostMapping("/findVisitStepDisplayActivityExecutionEsList")
    @CrmLog
    public Result<PageResult<SfaVisitStepStoreDisplayActivityTableRespVo>> findVisitStepDisplayActivityExecutionEsList(@RequestBody GetCompleteActivityTablePageReq req) {
        PageResult<SfaVisitStepStoreDisplayActivityTableRespVo> result = sfaVisitStepActivityExecutionServiceEs.findVisitStepDisplayActivityExecutionEsList(req);
        return Result.ok(result);
    }

    /**
     * 费用活动执行报表详情
     */
    @ApiOperation(value = "费用活动执行报表详情")
    @PostMapping("/findVisitStepCostActivityExecutionDetailEs")
    @CrmLog
    public Result<SfaVisitStepActivityCostExecutionEsData> findVisitStepCostActivityExecutionDetailEs(@RequestParam String id) {
        SfaVisitStepActivityCostExecutionEsData result = sfaVisitStepActivityExecutionServiceEs.findVisitStepCostActivityExecutionDetailEs(id);
        return Result.ok(result);
    }

    /**
     * 陈列活动执行报表详情
     */
    @ApiOperation(value = "陈列活动执行报表详情")
    @PostMapping("/findVisitStepDisplayActivityExecutionDetailEs")
    @CrmLog
    public Result<SfaVisitStepActivityDisplayExecutionEsData> findVisitStepDisplayActivityExecutionDetailEs(@RequestParam String id) {
        SfaVisitStepActivityDisplayExecutionEsData result = sfaVisitStepActivityExecutionServiceEs.findVisitStepDisplayActivityExecutionDetailEs(id);
        return Result.ok(result);
    }

}
