package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepLoggingDataRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 拜访步骤(竞品采集);
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepcollet")
@Api(tags = "拜访步骤(竞品采集);")
public class SfaVisitStepColletController {
    @Resource
    private ISfaVisitStepColletService sfaVisitStepColletService;


    /**
     * 工作台竞品采集
     */
    @ApiOperation(value = "工作台-竞品采集")
    @PostMapping("/save")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result save(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
        //工作台不需要visitId
        sfaVisitStepColletReqVo.setVisitId(null);
        sfaVisitStepColletService.save(null);
        return Result.ok();
    }


}
