package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.visitstep.req.SfaLogRecordReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletProductReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReportReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaLogRecordRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletProductRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.req.GetColletTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepColletReportTableRespVo;
import com.biz.crm.visitstep.service.ISfaLogRecordService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletProductService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepColletServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 竞品商品;
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepcolletproduct")
@Api(tags = "竞品商品")
public class SfaVisitStepColletProductController {
    @Resource
    private ISfaVisitStepColletProductService sfaVisitStepColletProductService;
    @Resource
    private SfaVisitStepColletServiceEsImpl sfaVisitStepColletServiceEs;

    @Autowired
    private ISfaLogRecordService sfaLogRecordService;


    /**
     * 竞品商品列表(web)
     */
    @ApiOperation(value = "竞品商品列表(web)")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitStepColletProductRespVo>> list(@RequestBody SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        PageResult<SfaVisitStepColletProductRespVo> result=sfaVisitStepColletProductService.findList(sfaVisitStepColletProductReqVo);
        return Result.ok(result);
    }

    /**
     * 竞品商品列表（小程序）
     */
    @ApiOperation(value = "竞品商品列表")
    @PostMapping("/productList")
    @CrmLog
    public Result<PageResult<SfaVisitStepColletProductRespVo>> productList(@RequestBody SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        PageResult<SfaVisitStepColletProductRespVo> result=sfaVisitStepColletProductService.findListProduct(sfaVisitStepColletProductReqVo);
        return Result.ok(result);
    }

    /**
     * 竞品商品报表
     */
    @ApiOperation(value = "竞品商品报表")
    @PostMapping("/reportFormsList")
    @CrmLog
    @Deprecated
    public Result<PageResult<SfaVisitStepColletReportRespVo>>  reportFormsList(@RequestBody SfaVisitStepColletReportReqVo sfaVisitStepColletProductReqVo) {
        PageResult<SfaVisitStepColletReportRespVo> result=sfaVisitStepColletProductService.findReportFormsList(sfaVisitStepColletProductReqVo);
        return Result.ok(result);
    }

    /**
     * 竞品商品报表
     */
    @ApiOperation(value = "竞品商品报表")
    @PostMapping("/reportFormsEsList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitStepColletReportTableRespVo>>  reportFormsEsList(@RequestBody GetColletTablePageReq req) {

        PageResult<SfaVisitStepColletReportTableRespVo> result=this.sfaVisitStepColletServiceEs.findReportFormsEsList(req);
        return Result.ok(result);
    }


    /**
     * 竞品商品报表详情
     */
    @ApiOperation(value = "竞品商品详情",httpMethod = "GET")
    @GetMapping("/queryReportForms")
    @Deprecated
    @CrmLog
    public Result<SfaVisitStepColletReportRespVo>  queryReportForms(@RequestParam("id") String id) {
        return Result.ok(sfaVisitStepColletProductService.findReportFormsOne(id));
    }

    /**
     * 竞品商品报表详情
     */
    @ApiOperation(value = "竞品商品详情",httpMethod = "GET")
    @GetMapping("/queryReportFormsEs")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitStepColletReportTableRespVo>  queryReportFormsEs(@RequestParam("id") String id) {
        return Result.ok(this.sfaVisitStepColletServiceEs.findReportFormsEsDetail(id));
    }

    /**
     * 竞品商品日志详情
     */
    @ApiOperation(value = "竞品商品管理日志列表")
    @PostMapping("/updateLog")
    @CrmLog
    public Result<PageResult<SfaLogRecordRespVo>> updateLog(@RequestBody SfaLogRecordReqVo sfaLogRecordReqVo) {
        PageResult<SfaLogRecordRespVo> result = sfaLogRecordService.findList(sfaLogRecordReqVo);
        return Result.ok(result);
    }


    /**
     * 查询
     */
    @ApiOperation(value = "查询",httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
    })
    @GetMapping("/query")
    @CrmLog
    public Result<SfaVisitStepColletProductRespVo> query(@RequestParam("id") String id) {
        SfaVisitStepColletProductRespVo respVo=sfaVisitStepColletProductService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        sfaVisitStepColletProductService.save(sfaVisitStepColletProductReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        sfaVisitStepColletProductService.update(sfaVisitStepColletProductReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除",httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitStepColletProductService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用",httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitStepColletProductService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用",httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitStepColletProductService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
