package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInoutReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepInoutRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepInoutService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 拜访步骤(进离店) 
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepinout")
@Api(tags = "拜访步骤(进离店) ")
public class SfaVisitStepInoutController {
    @Resource
    private ISfaVisitStepInoutService sfaVisitStepInoutService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitStepInoutRespVo>> list(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
        PageResult<SfaVisitStepInoutRespVo> result=sfaVisitStepInoutService.findList(sfaVisitStepInoutReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaVisitStepInoutRespVo> query(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
        SfaVisitStepInoutRespVo respVo=sfaVisitStepInoutService.query(sfaVisitStepInoutReqVo);
        return Result.ok(respVo);
    }


    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @CrmAPIDiscard
    public Result delete(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
        sfaVisitStepInoutService.deleteBatch(sfaVisitStepInoutReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
        sfaVisitStepInoutService.enableBatch(sfaVisitStepInoutReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody  SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
        sfaVisitStepInoutService.disableBatch(sfaVisitStepInoutReqVo);
        return Result.ok("禁用成功");
    }
}
