package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderDetailReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderStockAnalysisReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.*;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.req.GetOrderPageTableReq;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderFormService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepOrderServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author ren.gang
 * @ClassName SfaVisitStepOrderFormController.java
 * @Description 任钢
 * @createTime 2021年01月12日 14:03:00
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitStepOrderForm")
@Api(tags = "后台-订单管理-报表接口")
public class SfaVisitStepOrderFormController {

    @Resource
    private ISfaVisitStepOrderFormService sfaVisitStepOrderFormService;
    @Resource
    private SfaVisitStepOrderServiceEsImpl sfaVisitStepOrderServiceEs;
    @Autowired
    private ISfaVisitStepOrderService sfaVisitStepOrderService;

    @ApiOperation(value = "订单明细报表")
    @PostMapping("/orderDetail")
    @CrmLog
    @Deprecated
    public Result<PageResult<SfaVisitStepOrderDetailRespVo>> orderDetail(@RequestBody SfaVisitStepOrderDetailReqVo reqVo) {

        return Result.ok(sfaVisitStepOrderFormService.orderDetail(reqVo));
    }

    @ApiOperation(value = "订单明细报表")
    @PostMapping("/orderDetailEs")
    @CrmLog
    @Deprecated
    public Result<PageResult<SfaVisitStepOrderTableRespVo>> orderDetail(@RequestBody GetOrderPageTableReq reqVo) {
        PageResult<SfaVisitStepOrderTableRespVo> orderTable = sfaVisitStepOrderServiceEs.getOrderTable(reqVo);
        return Result.ok(orderTable);
    }


    @ApiOperation(value = "订单明细报表")
    @CrmLog
    @PostMapping("orderDetailReport")
    public Result<PageResult<SfaVisitStepOrderRespVo>> orderDetailReport(@RequestBody SfaVisitStepOrderReqVo reqVo){
        return Result.ok(sfaVisitStepOrderService.orderDetailReport(reqVo));
    }

    @ApiOperation(value = "订单明细")
    @PostMapping("/orderInfo")
    @CrmLog
    public Result<SfaVisitStepOrderDetailRespVo> orderInfo(@RequestBody String id) {

        return Result.ok(sfaVisitStepOrderFormService.orderInfo(id));
    }

    @ApiOperation(value = "订单明细(方案活动)")
    @PostMapping("/orderInfoProgramme")
    @CrmAPIDiscard
    @Deprecated
    @CrmLog
    public Result<SfaVisitStepOrderDetailProRespVo> orderInfoProgramme(@RequestBody String id) {

        return Result.ok(sfaVisitStepOrderFormService.orderInfoProgramme(id));
    }

    @ApiOperation(value = "终端进货量分析")
    @PostMapping("/stockAnalysis")
    @CrmLog
    public Result<PageResult<SfaVisitStepOrderStockAnalysisRespVo>> stockAnalysis(@RequestBody SfaVisitStepOrderStockAnalysisReqVo reqVo) {

        return Result.ok(sfaVisitStepOrderFormService.stockAnalysis(reqVo));
    }
}
