package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.req.GetStoreCheckReq;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCheckTableRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepStoreCheckServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 拜访步骤(店面检查);
 *
 * @author lf
 * @date 2020-12-29 23:06:39
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepstorecheck")
@Api(tags = "拜访步骤(店面检查);")
public class SfaVisitStepStoreCheckController {
    @Resource
    private SfaVisitStepStoreCheckServiceEsImpl sfaVisitStepStoreCheckServiceEsImpl;



    /**
     * 查询店面检查报表
     *
     * @return
     */
    @CrmLog
    @ApiOperation(value = "查询店面检查报表")
    @PostMapping("findStoreCheckReportEsList")
    public Result<PageResult<SfaVisitStepStoreCheckTableRespVo>> findStoreCheckReportEsList(@RequestBody GetStoreCheckReq req) {
        PageResult<SfaVisitStepStoreCheckTableRespVo> result = sfaVisitStepStoreCheckServiceEsImpl.findStoreCheckReportEsList(req);
        return Result.ok(result);
    }

    /**
     * 通过id查询店面检查报表详细信息
     * @param id
     * @return
     */
    @CrmLog
    @ApiOperation(value = "通过id查询店面检查报表详细信息")
    @GetMapping("findStoreCheckReportDetailEs")
    public Result<SfaVisitStepStoreCheckRespVo> findStoreCheckReportDetailEs(@RequestParam String id){
        SfaVisitStepStoreCheckRespVo respVo = sfaVisitStepStoreCheckServiceEsImpl.findStoreCheckReportDetailEs(id);
        return Result.ok(respVo);
    }


}
