package com.biz.crm.visitstep.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReportReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepLoggingDataRespVo;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.visitstep.req.GetColletTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepColletReportTableRespVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import java.util.List;
import java.util.Map;

/**
 * 拜访步骤(竞品采集);
 * 
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface SfaVisitStepColletMapper extends BaseMapper<SfaVisitStepColletEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitStepColletReqVo
     * @return
     */
    List<SfaVisitStepColletRespVo> findList(Page<SfaVisitStepColletRespVo> page, @Param("vo") SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 报表列表
      * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sc.create_org_code",posCode = "sc.create_pos_code")
    List<SfaVisitStepColletReportRespVo> findReportList(Page<SfaVisitStepColletReportRespVo> page, @Param("vo")SfaVisitStepColletReportReqVo reqVo);


    /**
     * 根据id查询
     * @param id
     * @return
     */
    SfaVisitStepColletReportRespVo findReportOneById(@Param("id") String id);

    /**
     * 根据clientId查询指定数据列表
     * @param page
     * @param sfaVisitStepColletReqVo
     * @return
     */
    List<SfaVisitStepLoggingDataRespVo> findRecordList(Page<SfaVisitStepColletRespVo> page, @Param("vo") SfaVisitStepColletReqVo sfaVisitStepColletReqVo, @Param("ids") List<String> ids);

    /**
     * 根据终端id拿到竞品记录id集合
     * @param clientId
     * @return
     */
    List<String> findIdsByClientId(@Param("clientId") String clientId);

    /**
     * 查询竞品报表
     * @param page
     * @param req
     * @return
     */
    List<SfaVisitStepColletReportTableRespVo> findCollectReportList(Page<SfaVisitStepColletReportTableRespVo> page, @Param("vo")GetColletTablePageReq req);

}
