package com.biz.crm.visitstep.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.visitstep.req.GetOrderPageReq;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import java.util.List;
import java.util.Map;

/**
 * 拜访步骤(订单主表);
 * 
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface SfaVisitStepOrderMapper extends BaseMapper<SfaVisitStepOrderEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitStepOrderReqVo
     * @return
     */
    List<SfaVisitStepOrderRespVo> findList(Page<SfaVisitStepOrderRespVo> page, @Param("vo") SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * web端-查询订单明细报表
     * @param page
     * @param sfaVisitStepOrderReqVo
     * @return
     */
    @SqlPrivilege(posCode = "pos_code", orgCode = "org_code")
    List<SfaVisitStepOrderRespVo> findOrderReportList(Page<SfaVisitStepOrderRespVo> page, @Param("vo") SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 工作台-查询订单采集列表
     * @param page
     * @param req
     * @return
     */
    List<SfaVisitStepOrderRespVo> findWorkbenchOrderPage(Page<SfaVisitStepOrderRespVo> page,@Param("vo") GetOrderPageReq req);


    /**
     * 查询订单数量
     */
    List<SfaVisitStepOrderRespVo> getVisitNum(@Param("firstDay")String firstDay,@Param("lastDay")String lastDay,@Param("createCode")String createCode);
}
