package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访(陈列执行配置) 实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_log_record")
@CrmTable(name = "sfa_log_record", tableNote = "拜访(陈列执行配置)")
public class SfaLogRecordEntity extends CrmExtTenEntity<SfaLogRecordEntity> {

    /**
     * 日志类型
     */
    @CrmColumn(name = "log_type", length = 32, note = "日志类型")
    private String logType;

    /**
     * 关联业务ID
     */
    @CrmColumn(name = "business_id", length = 32, note = "关联业务ID")
    private String businessId;


}
