package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访(陈列执行配置) 实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_display_config")
@CrmTable(name = "sfa_visit_display_config", tableNote = "拜访(陈列执行配置)")
public class SfaVisitDisplayConfigEntity extends CrmExtTenEntity<SfaVisitDisplayConfigEntity> {

    /**
     * 标签名称
     */
    @CrmColumn(name = "label_name", length = 100, note = "标签名称")
    private String labelName;

    /**
     * 标签描述
     */
    @CrmColumn(name = "label_desc", length = 200, note = "标签描述")
    private String labelDesc;

    /**
     * 照片数量要求
     */
    @CrmColumn(name = "pic_limit", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "照片数量要求")
    private Integer picLimit;

    /**
     * 照片类型
     */
    @CrmColumn(name = "pic_type", length = 60, note = "照片类型")
    private String picType;

}
