package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访步骤(活动执行);实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_activity")
@CrmTable(name = "sfa_visit_step_activity", tableNote = "拜访步骤(活动执行);")
public class SfaVisitStepActivityEntity extends CrmExtTenEntity<SfaVisitStepActivityEntity> {

    /**
     * 拜访id
     */
    @CrmColumn(name = "visit_id", length = 32, note = "拜访id")
    private String visitId;

    /**
     * 活动类型
     */
    @CrmColumn(name = "act_type", length = 32, note = "活动类型")
    private String actType;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32, note = "活动编码")
    private String actCode;
    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 200, note = "活动名称")
    private String actName;

    /**
     * 网点id
     */
    @CrmColumn(name = "client_id", length = 40, note = "网点id")
    private String clientId;

    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 活动开始时间
     */
    @CrmColumn(name = "begin_date", length = 32, note = "活动开始时间")
    private String beginDate;

    /**
     * 活动结束时间
     */
    @CrmColumn(name = "end_date", length = 32, note = "活动结束时间")
    private String endDate;

    /**
     * 活动执行频率(陈列活动)
     */
    @CrmColumn(name = "act_frequency", length = 100, note = "活动执行频率(陈列活动)")
    private String actFrequency;

    /**
     * 活动要求、描述
     */
    @CrmColumn(name = "act_require", length = 512, note = "活动要求、描述")
    private String actRequire;

    /**
     * 预估销售额(费用活动)
     */
    @CrmColumn(name = "predict_sales", mysqlType = "decimal(32,6)", oracleType = "NUMBER(32,6)", note = "预估销售额(费用活动)")
    private BigDecimal predictSales;

    /**
     * 金额(费用活动)
     */
    @CrmColumn(name = "amount", mysqlType = "decimal(32,6)", oracleType = "NUMBER(32,6)", note = "金额(费用活动)")
    private BigDecimal amount;

    /**
     * 客户编码(费用活动)
     */
    @CrmColumn(name = "customer_code", length = 32, note = "客户编码(费用活动)")
    private String customerCode;

    /**
     * 客户名称(费用活动)
     */
    @CrmColumn(name = "customer_name", length = 200, note = "客户名称(费用活动)")
    private String customerName;


}
