package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.*;

import javax.persistence.Index;
import javax.persistence.Transient;
import java.util.StringJoiner;


/**
 * 活动执行明细;实体类
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
@Getter
@Setter
@TableName(SfaVisitStepActivityExecutionEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepActivityExecutionEntity.TABLE_NAME, tableNote = "活动执行明细", indexes = {
        @Index(name = SfaVisitStepActivityExecutionEntity.TABLE_NAME + "_index1", columnList = "step_code, client_code, pos_code, user_name, org_code"),
        @Index(name = SfaVisitStepActivityExecutionEntity.TABLE_NAME + "_index2", columnList = "activity_date"),
        @Index(name = SfaVisitStepActivityExecutionEntity.TABLE_NAME + "_index3", columnList = "activity_code"),
        @Index(name = SfaVisitStepActivityExecutionEntity.TABLE_NAME + "_index4", columnList = "activity_execution_id")})
public class SfaVisitStepActivityExecutionEntity extends CrmObjTenEntity<SfaVisitStepActivityExecutionEntity> implements VisitStepListener.VisitStepListenerCommittedData {
    public static final String TABLE_NAME = "sfa_visit_step_activity_execution";
    @CrmColumn(name = "redis_hash_key")
    @Field(type = FieldType.Keyword)
    private String redisHashKey;
    @ApiModelProperty("表单id")
    @CrmColumn(name = "form_id", note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;
    @ApiModelProperty("步骤编码")
    @CrmColumn(name = "step_code", note = "步骤编码")
    @Field(type = FieldType.Keyword)
    private String stepCode;

    /**
     * 活动执行类型(0-费用活动,1-陈列活动)
     */
    @CrmColumn(name = "activity_type", length = 64, note = "活动执行类型(0-费用活动,1-陈列活动)")
    @Field(type = FieldType.Keyword)
    private String activityType;


    /**
     * 活动id
     */
    @CrmColumn(name = "activity_execution_id", length = 32, note = "活动id")
    @Field(type = FieldType.Keyword)
    private String activityExecutionId;

    @ApiModelProperty("活动编码")
    @CrmColumn(name = "activity_code", length = 32, note = "活动编码")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String activityCode;

    @ApiModelProperty("活动执行明细状态")
    @CrmColumn(name = "execute_status", length = 32, note = "活动执行明细状态")
    @Field(type = FieldType.Keyword)
    private String executeStatus;

    @ApiModelProperty("活动执行明细状态失败说明")
    @CrmColumn(name = "execute_msg", length = 80, note = "活动执行明细状态失败说明")
    private String executeMsg;

    @CrmColumn(name = "visit_plan_info_id", length = 64, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;


    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String clientName;

    /**
     * 客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)
     */
    @CrmColumn(name = "client_type", length = 32, note = "客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    @Field(type = FieldType.Keyword)
    private String clientType;

    /**
     * 网点类型;协访网点类型
     */
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String clientTypeName;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String clientSubclassName;

    /**
     * 活动执行时间
     */
    @CrmColumn(name = "activity_time", length = 32, note = "活动执行时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
//    @Field(format= DateFormat.custom, pattern = "yyyy-MM-dd HH:mm:ss", type = FieldType.Date)
    private String activityTime;


    @CrmColumn(name = "activity_date", length = 16, note = "活动执行日期")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String activityDate;

    @CrmColumn(name = "activity_year_month", length = 8, note = "活动执行年月")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String activityYearMonth;

    @CrmColumn(name = "activity_year", length = 4, note = "活动执行年份")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String activityYear;


    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 32, note = "人员账号")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 32, note = "人员姓名")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String realName;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 32, note = "职位名称")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String posName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String posCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 32, note = "组织名称")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String orgName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "组织编码")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String orgCode;

    /**
     * 活动执行地址
     */
    @CrmColumn(name = "activity_execution_address", length = 100, note = "活动执行地址")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String activityExecutionAddress;

    /**
     * 经度
     */
    @CrmColumn(name = "longitude", length = 32, note = "经度")
    private String longitude;

    /**
     * 纬度
     */
    @CrmColumn(name = "latitude", length = 32, note = "纬度")
    private String latitude;

    @Getter(AccessLevel.NONE)
    @GeoPointField
    @Transient
    @TableField(exist = false)
    private String geoPoint;

    public String getGeoPoint() {
        if(StringUtils.isBlank(longitude) || StringUtils.isBlank(latitude)){
            return null;
        }
        return new StringJoiner(",").add(latitude).add(longitude).toString();
    }

    /**
     * 活动名称
     */
    @CrmColumn(name = "activity_name", length = 100, note = "活动名称")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String activityName;

    /**
     * 活动执行开始时间
     */
    @CrmColumn(name = "activity_start_time", length = 32, note = "活动执行开始时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String activityStartTime;

    /**
     * 活动执行结束时间
     */
    @CrmColumn(name = "activity_end_time", length = 32, note = "活动执行结束时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String activityEndTime;

    /**
     * 活动频率
     */
    @CrmColumn(name = "activity_frequency", length = 32, note = "活动频率")
    @Mapping(mappingPath = "es-mapping/text-def.json")
    private String activityFrequency;



}
