package com.biz.crm.visitstep.model;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@Data
public class SfaVisitStepColletRedisData extends SfaVisitStepColletEntity {
    public static SfaVisitStepColletRedisData getInstance(){
        return SfaVisitStepColletRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitStepColletRedisData instance = new SfaVisitStepColletRedisData();
    }

    /**
     * 数据状态(offline-离线，online-在线)
     */
    private SfaVisitEnum.VISIT_OFF_LINE lineType;

    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(stepCode);
    }


    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    @ApiModelProperty("竞品商品清单")
    @Field(type = FieldType.Nested)
    private List<CompetitorStepExecuteData.ColletItemReqVo> sfaVisitStepColletItemReqVos;
    @ApiModelProperty("竞品图片列表")
    private List<CrmAttachment> sfaVisitPictureReqVos;

}
