package com.biz.crm.visitstep.model;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmAttachmentContainer6;
import com.biz.crm.base.CrmEsDefDocument;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.sqlupdate.CrmColumn;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;

import java.util.List;


/**
 *
 * 拜访相关主数据：
 * 人员维度：
 * 当前所在组织、登陆账号、人员姓名、联系方式、职位名称、职位编码、角色名称、角色编码、上级
 * 客户维度：
 * 客户名称、客户编码、客户地址、客户所在组织、主联系人姓名、主联系人电话、对接人姓名、对接人电话、客户类型、渠道、上级客户、上级公司、店招图片
 *
 * 默认步骤模板
 *  @author: luoqi
 *  @Date: 2021-3-22 21:06
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
@ApiModel("默认步骤模板实体")
public class SfaVisitStepDefaultEntity extends CrmEsDefDocument<SfaVisitStepDefaultEntity> implements ClientReq, CrmAttachmentContainer6, VisitStepExecuteReq.StepExecuteDataReq, VisitStepListener.VisitStepListenerCommittedData {
    /**
     * ES 索引
     */
    public final static String TABLE_NAME = "sfa_visit_step_default";

    @CrmColumn(name = "redis_hash_key", note = "表单id")
    private String redisHashKey;

    @CrmColumn(name = "form_id", length = 32, note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;

    @CrmColumn(name = "visit_plan_info_id", length = 64, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;

    @ApiModelProperty("步骤编码")
    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    @ApiModelProperty("纬度在前,经度在后-英文逗号间隔")
    @CrmColumn(name = "geo_point", length = 64,  note = "纬度在前,经度在后-英文逗号间隔")
    @GeoPointField
    private String geoPoint;

    @ApiModelProperty("定位地址信息")
    @CrmColumn(name = "address", note = "定位地址信息")
    private String address;


//    人员维度：
//    CrmBaseEntity ： 当前所在组织、登陆账号、人员姓名、职位名称、职位编码、角色名称、角色编码
//    this : 联系方式、上级
    @ApiModelProperty("创建人联系方式")
    @CrmColumn(name = "create_user_phone", length = 64, note = "创建人联系方式")
    private String createUserPhone = this.getCreateName();

    @ApiModelProperty("创建人上级职位编码")
    @CrmColumn(name = "create_pos_code_supper", length = 64, note = "创建人上级职位编码")
    private String createPosCodeSupper;

    @ApiModelProperty("创建人上级职位编码")
    @CrmColumn(name = "create_pos_name_supper", length = 64, note = "创建人上级职位编码")
    private String createPosNameSupper;

//    客户维度：
//    this : 客户名称、客户编码、客户类型、渠道、客户所在组织、客户地址、主联系人姓名、主联系人电话、
//    对接人姓名、对接人电话、上级客户、上级公司、店招图片
    @ApiModelProperty("客户名称")
    @CrmColumn(name = "client_name", length = 64, note = "客户名称")
    private String clientName;

    @ApiModelProperty("客户编码")
    @CrmColumn(name = "client_code", length = 64, note = "客户编码")
    private String clientCode;

    @ApiModelProperty("客户类型")
    @CrmColumn(name = "client_type", length = 64, note = "客户类型")
    private String clientType;

    /**
     * 网点类型;协访网点类型
     */
    @ApiModelProperty("网点类型")
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    @ApiModelProperty("客户渠道")
    @CrmColumn(name = "channel", length = 64, note = "客户渠道")
    private String channel;

    @ApiModelProperty("客户渠道")
    @CrmColumn(name = "channel_name", length = 64, note = "客户渠道")
    private String channelName;

    @ApiModelProperty("客户所在组织编码")
    @CrmColumn(name = "client_org_code", length = 64, note = "客户所在组织编码")
    private String clientOrgCode;

    @ApiModelProperty("客户所在组织")
    @CrmColumn(name = "client_org_name", length = 64, note = "客户所在组织")
    private String clientOrgName;

    @ApiModelProperty("客户地址")
    @CrmColumn(name = "client_address", length = 64, note = "客户地址")
    private String clientAddress;

    @ApiModelProperty("主联系人姓名")
    @CrmColumn(name = "client_contact", length = 64, note = "主联系人姓名")
    private String clientContact;

    @ApiModelProperty("主联系人电话")
    @CrmColumn(name = "client_contact_phone", length = 64, note = "主联系人电话")
    private String clientContactPhone;

    @ApiModelProperty("对接人姓名")
    @CrmColumn(name = "client_supply", length = 64, note = "对接人姓名")
    private String clientSupply;

    @ApiModelProperty("对接人电话")
    @CrmColumn(name = "client_supply_phone", length = 64, note = "对接人电话")
    private String clientSupplyPhone;

    @ApiModelProperty("上级客户编码")
    @CrmColumn(name = "client_code_supper", length = 64, note = "上级客户编码")
    private String clientCodeSupper;

    @ApiModelProperty("上级客户名称")
    @CrmColumn(name = "client_name_supper", length = 64, note = "上级客户名称")
    private String clientNameSupper;

    @ApiModelProperty("上级公司编码")
    @CrmColumn(name = "company_code_supper", length = 64, note = "上级公司编码")
    private String companyCodeSupper;

    @ApiModelProperty("上级公司名称")
    @CrmColumn(name = "company_name_supper", length = 64, note = "上级公司名称")
    private String companyNameSupper;

    @ApiModelProperty("店招图片")
    @CrmColumn(name = "client_pic_url", length = 64, note = "店招图片")
    private String clientPicUrl;





//  #############附件容器############

    @ApiModelProperty("附件容器1")
    private List<CrmAttachment> attachmentExt1;

    @ApiModelProperty("附件容器2")
    private List<CrmAttachment> attachmentExt2;

    @ApiModelProperty("附件容器3")
    private List<CrmAttachment> attachmentExt3;

    @ApiModelProperty("附件容器4")
    private List<CrmAttachment> attachmentExt4;

    @ApiModelProperty("附件容器5")
    private List<CrmAttachment> attachmentExt5;

    @ApiModelProperty("附件容器6")
    private List<CrmAttachment> attachmentExt6;

    /**
     * 附件容器命名空间,建议返回表名
     *
     * @return
     */
    @Override
    public String attachmentNameScope() {
        return TABLE_NAME;
    }


//    public void initAttachmentExt(){
//        this.attachmentExt1 = Lists.newArrayList();
//        this.attachmentExt2 = Lists.newArrayList();
//        this.attachmentExt3 = Lists.newArrayList();
//        this.attachmentExt4 = Lists.newArrayList();
//        this.attachmentExt5 = Lists.newArrayList();
//        this.attachmentExt6 = Lists.newArrayList();
//    }

}
