package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 拜访步骤表单_实体
 * @author YuanZiJian
 * @date 2021/2/4 10:37
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName(value = SfaVisitStepFromEntity.TABLE_NAME)
@CrmTable(name = "sfa_step_form", tableNote = "拜访步骤表单")
public class SfaVisitStepFromEntity extends CrmExtTenEntity {
    public static final long CACHE_TIME = 3600 * 24 * 30;
    /**
     * 方案活动表单的ID
     */
    public static final String FORM_ID_AS = "FORM_ID_AS";
    /**
     * 配置时的默认值
     */
    public static final String FORM_DEF_VAL = "";
    public static final String TABLE_NAME = "SFA_STEP_FORM";
    /**
     * 步骤表单名称
     */
    @CrmColumn(name = "from_name", length = 60, note = "步骤表单名称")
    private String fromName;
    /**
     * 拜访类型
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型")
    private String visitType;
    /**
     * 客户类型
     */
    @CrmColumn(name = "customer_type", length = 32, note = "客户类型")
    private String customerType;

    /**
     * 客户细类
     */
    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    private String clientSubclass;

    /**
     * 客户细类
     */
    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;
    /**
     * 有效期类型
     */
    @CrmColumn(name = "time_type", length = 32, note = "有效期类型")
    private String timeType;
    /**
     * 有效期开始时间
     */
    @CrmColumn(name = "start_time", length = 32, note = "有效期开始时间")
    private String startTime;
    /**
     * 有效期结束时间
     */
    @CrmColumn(name = "end_time", length = 32, note = "有效期结束时间")
    private String endTime;
    /**
     * 步骤logo
     */
    @CrmColumn(name = "icon", length = 2000, note = "步骤logo")
    private String icon;
    /**
     * 页面编码
     */
    @CrmColumn(name = "page_code", length = 256, note = "页面编码")
    private String pageCode;

    /**
     * 步骤编码
     */
    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    /**
     * 是否获取定位信息
     */
    @CrmColumn(name = "locate_type", length = 10, note = "是否获取定位信息")
    private String locateType;

    /**
     * 距离
     */
    @CrmColumn(name = "distance",length = 32,note = "距离")
    private String distance;
}
