package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 步骤表单模块关系_实体
 *
 * @author YuanZiJian
 * @date 2021/2/4 10:43
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName(value = "sfa_step_form_model")
@CrmTable(name = "sfa_step_form_model", tableNote = "步骤表单模块关系")
public class SfaVisitStepFromModelEntity extends CrmExtTenEntity {
    /**
     * 与控件关联的表单编码
     */
    @CrmColumn(name = "from_id", length = 32, note = "与控件关联的表单编码")
    private String fromId;
    /**
     * 模块名称
     */
    @CrmColumn(name = "model_name", length = 60, note = "模块名称")
    private String modelName;
    /**
     * 模块logo
     */
    @CrmColumn(name = "model_icon", length = 2000, note = "模块logo")
    private String modelIcon;
    /**
     * 模块顺序
     */
    @CrmColumn(name = "model_sort", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "模块顺序")
    private String modelSort;


}
