package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访步骤(进离店) 实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_inout")
@CrmTable(name = "sfa_visit_step_inout", tableNote = "拜访步骤(进离店)")
public class SfaVisitStepInoutEntity extends CrmExtTenEntity<SfaVisitStepInoutEntity> {

    /**
     * 拜访编码 关联拜访计划
     */
    @CrmColumn(name = "visit_id", length = 32, note = "拜访编码 关联拜访计划")
    private String visitId;

    /**
     * 拜访类型
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型")
    private String visitType;

    /**
     * 拜访类型日期
     */
    @CrmColumn(name = "visit_date", length = 32, note = "拜访类型日期")
    private String visitDate;

    /**
     * 网点id
     */
    @CrmColumn(name = "client_id", length = 40, note = "网点id")
    private String clientId;

    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 进店时间
     */
    @CrmColumn(name = "in_time", length = 32, note = "进店时间")
    private String inTime;

    /**
     * 进店地址
     */
    @CrmColumn(name = "in_address", length = 200, note = "进店地址")
    private String inAddress;

    /**
     * 离店时间
     */
    @CrmColumn(name = "out_time", length = 32, note = "离店时间")
    private String outTime;

    /**
     * 离店地址
     */
    @CrmColumn(name = "out_address", length = 200, note = "离店地址")
    private String outAddress;

}
