package com.biz.crm.visitstep.model;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@Data
public class SfaVisitStepOrderRedisData extends SfaVisitStepOrderEntity {
    public static SfaVisitStepOrderRedisData getInstance(){
        return SfaVisitStepOrderRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitStepOrderRedisData instance = new SfaVisitStepOrderRedisData();
    }

    /**
     * 数据状态(offline-离线，online-在线)
     */
    private SfaVisitEnum.VISIT_OFF_LINE lineType;

    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(stepCode);
    }

    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    private List<OrderAsDataReq.OrderItemAsReqVo> sfaVisitStepOrderItems;


}
