package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访步骤(库存盘点);实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_stock")
@CrmTable(name = "sfa_visit_step_stock", tableNote = "拜访步骤(库存盘点);")
public class SfaVisitStepStockEntity extends CrmExtTenEntity<SfaVisitStepStockEntity> {

    /**
     * 库存盘点类型(备用涉及周盘、月盘、年盘)
     */
    @CrmColumn(name = "stock_type", length = 32, note = "库存盘点类型(备用涉及周盘、月盘、年盘)")
    private String stockType;

    /**
     * 拜访编码
     */
    @CrmColumn(name = "visit_id", length = 32, note = "拜访编码")
    private String visitId;

    /**
     * 网点id
     */
    @CrmColumn(name = "client_id", length = 40, note = "网点id")
    private String clientId;

    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 200, note = "产品名称")
    private String productName;

    /**
     * 系列编码
     */
    @CrmColumn(name = "series_code", length = 32, note = "系列编码")
    private String seriesCode;

    /**
     * 系列名称
     */
    @CrmColumn(name = "series_name", length = 200, note = "系列名称")
    private String seriesName;

    /**
     * 数量
     */
    @CrmColumn(name = "quantity", mysqlType = "decimal(6,2)", oracleType = "NUMBER(6,2)", note = "数量")
    private BigDecimal quantity;

    /**
     * 单位
     */
    @CrmColumn(name = "unit", length = 32, note = "单位")
    private String unit;

    /**
     * 
     */
    @CrmColumn(name = "untitled", length = 32)
    private String untitled;

}
