package com.biz.crm.visitstep.model;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmAttachmentContainer6;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 拜访步骤(店面检查);实体类
 *
 * @author lf
 * @date 2020-12-29 23:06:39
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class SfaVisitStepStoreCheckRedisData extends SfaVisitStepStoreCheckEntity implements CrmAttachmentContainer6 {
    public static SfaVisitStepStoreCheckRedisData getInstance(){
        return SfaVisitStepStoreCheckRedisData.Instance.instance;
    }

    /**
     * 数据类型(offline-离线，online-在线)
     */
    private SfaVisitEnum.VISIT_OFF_LINE lineEnum;

    /**
     * 附件容器命名空间,建议返回表名
     *
     * @return
     */
    @Override
    public String attachmentNameScope() {
        return TABLE_NAME;
    }

    private static  class Instance{
        private static final SfaVisitStepStoreCheckRedisData instance = new SfaVisitStepStoreCheckRedisData();
    }
    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(stepCode);
    }

    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }


    @ApiModelProperty("常规货架陈列")
    private List<CrmAttachment> regularShelfDisplayList;
    @ApiModelProperty("物料陈列")
    private List<CrmAttachment> materialDisplayList;
    @ApiModelProperty("价格签")
    private List<CrmAttachment> priceList;


    @ApiModelProperty("附件容器1")
    private List<CrmAttachment> attachmentExt1;

    @ApiModelProperty("附件容器2")
    private List<CrmAttachment> attachmentExt2;

    @ApiModelProperty("附件容器3")
    private List<CrmAttachment> attachmentExt3;

    @ApiModelProperty("附件容器4")
    private List<CrmAttachment> attachmentExt4;

    @ApiModelProperty("附件容器5")
    private List<CrmAttachment> attachmentExt5;

    @ApiModelProperty("附件容器5")
    private List<CrmAttachment> attachmentExt6;

//    public void initAttachmentExt(){
//        this.attachmentExt1 = Lists.newArrayList();
//        this.attachmentExt2 = Lists.newArrayList();
//        this.attachmentExt3 = Lists.newArrayList();
//        this.attachmentExt4 = Lists.newArrayList();
//        this.attachmentExt5 = Lists.newArrayList();
//        this.attachmentExt6 = Lists.newArrayList();
//    }

}
