package com.biz.crm.visitstep.req;

import com.biz.crm.util.StringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

/**
 *
 * @author yangshan
 * @date 2021/4/22 20:08
 */
@Data
@ApiModel("协访评价报表请求")
public class GetHelpVisitEvaluateTableReq extends VisitStepPageReq {

    @ApiModelProperty("客户名称")
    private String clientName;
    @ApiModelProperty("被协访人员账号")
    private String coverHelpUserName;
    @ApiModelProperty("被协访人员姓名")
    private String coverHelpRealName;
    @ApiModelProperty("被协访人员职位名称")
    private String coverHelpPosName;

    @ApiModelProperty("协访人员账号")
    private String userName;
    @ApiModelProperty("协访人员姓名")
    private String realName;
    @ApiModelProperty("协访人员职位名称")
    private String posName;
    @ApiModelProperty("开始时间")
    private String startTime;
    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("年月")
    private String yearMonth;

    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty(this.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", this.getClientName()));
        }
        if (StringUtils.isNotEmpty(this.getCoverHelpUserName())){
            builder.must(QueryBuilders.termQuery("coverHelpUserName.keyword", this.getCoverHelpUserName()));
        }
        if (StringUtils.isNotEmpty(this.getCoverHelpRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("coverHelpRealName", this.getCoverHelpRealName()));
        }
        if (StringUtils.isNotEmpty(this.getCoverHelpPosName())){
            builder.must(QueryBuilders.matchPhraseQuery("coverHelpPosName", this.getCoverHelpPosName()));
        }
        if (StringUtils.isNotEmpty(this.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", this.getRealName()));
        }
        if (StringUtils.isNotEmpty(this.getPosName())){
            builder.must(QueryBuilders.matchPhraseQuery("posName", this.getPosName()));
        }
        if (StringUtils.isNotEmpty(this.getUserName())){
            builder.must(QueryBuilders.termQuery("userName.keyword", this.getUserName()));
        }
        if (StringUtils.isNotEmpty(this.getStartTime())){
            builder.must(QueryBuilders.rangeQuery("scoreDate").gte(this.getStartTime()));
        }
        if (StringUtils.isNotEmpty(this.getEndTime())){
            builder.must(QueryBuilders.rangeQuery("scoreDate").lte(this.getEndTime()));
        }

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("scoreTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
