package com.biz.crm.visitstep.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@Data
@ApiModel("查询店面检查分页-参数")
public class GetOrderPageReq extends VisitStepPageReq{


    @ApiModelProperty("开始时间")
    private String startOrderTime;
    @ApiModelProperty("结束时间")
    private String endOrderTime;
    @ApiModelProperty("审批状态")
    private String approvalStatus;
    @ApiModelProperty("网点名称（客户名称)")
    private String clientName;
    @ApiModelProperty("职位编码")
    private String posCode;
    @ApiModelProperty("职位名称")
    private String posName;


    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
//        if(StringUtils.isBlank(this.getStepCode())){
//            throw new BusinessException("请指定步骤编码");
//        }

//        builder.must(QueryBuilders.termQuery("stepCode", this.getStepCode()));
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getPosCode())){
            builder.must(QueryBuilders.termQuery("posCode.keyword", this.getPosCode()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getPosName())){
            builder.must(QueryBuilders.matchQuery("posName", this.getPosName()));
        }

        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getApprovalStatus())){
            builder.must(QueryBuilders.termQuery("approvalStatus", this.getApprovalStatus()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getClientName())){
            builder.must(QueryBuilders.wildcardQuery("clientName.keyword","*"+this.getClientName()+"*"));
        }
//        builder.must(QueryBuilders.termQuery("clientCode", this.getClientCode()));
        if(StringUtils.isNotBlank(this.getStartOrderTime())){
            builder.must(QueryBuilders.rangeQuery("orderTime").from(this.getStartOrderTime()));
        }
        if(StringUtils.isNotBlank(this.getEndOrderTime())){
            builder.must(QueryBuilders.rangeQuery("orderTime").to(this.getEndOrderTime()));
        }



        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("orderTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
