package com.biz.crm.visitstep.req;

import com.biz.crm.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

import java.time.LocalDate;
import java.util.Date;

/**
 * @author yangshan
 * @date 2021年3月30日16:45:35
 */
@Data
@ApiModel("查询订单明细报表")
public class GetOrderPageTableReq extends VisitStepPageReq{


    @ApiModelProperty("订单编号")
    private String orderCode;
    @ApiModelProperty("客户编码")
    private String clientCode;
    @ApiModelProperty("客户名称")
    private String clientName;
    @ApiModelProperty("人员名称")
    private String realName;
    @ApiModelProperty("订单状态")
    private String approvalStatus;
    @ApiModelProperty("订单来源")
    private String orderSourceName;
    @ApiModelProperty("下单时间——按月筛选")
    private String yearMonth;

    @ApiModelProperty("开始时间")
    private String startDate;
    @ApiModelProperty("结束时间")
    private String endDate;




    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not

        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getOrderCode())){
            builder.must(QueryBuilders.termQuery("orderCode.keyword", this.getOrderCode()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", this.getRealName()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getApprovalStatus())){
            builder.must(QueryBuilders.termQuery("approvalStatus", this.getApprovalStatus()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getOrderSourceName())){
            builder.must(QueryBuilders.matchPhraseQuery("orderSourceName", this.getOrderSourceName()));
        }
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", this.getClientName()));
        }
//        builder.must(new PermissionPlugin.PayloadSearchQueryBuilder("ddd", "ggg"));
        if(com.biz.crm.util.StringUtils.isNotEmpty(this.getYearMonth())){
            Date firstDayOfMonth = DateUtil.getFirstDayOfMonth(DateUtil.str2Date(this.getYearMonth(), DateUtil.yyyy_MM));
            Date lastDayOfMonth = DateUtil.getLastDayOfMonth(DateUtil.str2Date(this.getYearMonth(), DateUtil.yyyy_MM));
            String firstFormat = DateUtil.format(firstDayOfMonth, DateUtil.DEFAULT_DATE_ALL_PATTERN);
            String lastFormat = DateUtil.format(lastDayOfMonth, DateUtil.DEFAULT_DATE_ALL_PATTERN);
            builder.must(QueryBuilders.rangeQuery("orderTime").gte(firstFormat));
            builder.must(QueryBuilders.rangeQuery("orderTime").lte(lastFormat));
        }
        if(StringUtils.isNotBlank(this.getStartDate())){
            builder.must(QueryBuilders.rangeQuery("orderTime").gte(this.getStartDate()));
        }
        if(StringUtils.isNotBlank(this.getEndDate())){
            builder.must(QueryBuilders.rangeQuery("orderTime").lte(this.getEndDate()));
        }

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("orderTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
