package com.biz.crm.visitstep.req;

import com.biz.crm.eunm.sfa.SfaVisitEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/4/6 10:09
 */
@Data
@ApiModel("查询异常提报分页-参数")
public class GetVisitStepAbnormalReq extends VisitStepPageReq {

    @ApiModelProperty("人员姓名")
    private String visitRealName;
    @ApiModelProperty("客户编码")
    private String clientCode;
    @ApiModelProperty("客户名称")
    private String clientName;
    @ApiModelProperty("职位名称")
    private String posName;
    @ApiModelProperty("提交时间（开始）")
    private String startTime;
    @ApiModelProperty("提交时间（结束）")
    private String endTime;
    @ApiModelProperty("拜访组织编码")
    private String visitOrgName;

    @ApiModelProperty("终端类型")
    private String clientType;

    @ApiModelProperty("终端类型")
    private String clientTypeDesc;

    @ApiModelProperty("职位编码")
    private String posCode;

    public NativeSearchQuery buildQuery(List<QueryBuilder> extQueryBuilders){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not

        builder.must(QueryBuilders.termQuery("visitStatus.keyword", SfaVisitEnum.visitStatus.V4.getVal()));
        if(StringUtils.isNotBlank(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if(StringUtils.isNotBlank(this.getClientName())){
            builder.must(QueryBuilders.wildcardQuery("clientName.keyword", "*" + this.getClientName() + "*"));
        }
        if(StringUtils.isNotBlank(this.getVisitRealName())){
            builder.must(QueryBuilders.wildcardQuery("visitRealName.keyword", "*" + this.getVisitRealName() + "*"));
        }
        if(StringUtils.isNotBlank(this.getPosName())){
            builder.must(QueryBuilders.wildcardQuery("visitPosName.keyword", "*" + this.getPosName() + "*"));
        }
        if(StringUtils.isNotBlank(this.getStartTime())){
            builder.must(QueryBuilders.rangeQuery("sfaVisitPlanInfoExecuteRedisData.exceptionTime").gte(this.getStartTime()));
        }
        if(StringUtils.isNotBlank(this.getEndTime())){
            builder.must(QueryBuilders.rangeQuery("sfaVisitPlanInfoExecuteRedisData.exceptionTime").lte(this.getEndTime()));
        }
        if(!CollectionUtils.isEmpty(extQueryBuilders)){
            for (QueryBuilder extQueryBuilder : extQueryBuilders) {
                if(null != extQueryBuilder){
                    builder.must(extQueryBuilder);
                }
            }
        }


        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("sfaVisitPlanInfoExecuteRedisData.exceptionTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;

    }
}
