package com.biz.crm.visitstep.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/4/22 20:33
 */
@Data
@ApiModel(value = "协访评价报表返回")
public class SfaHelpVisitEvaluateTableRespVo extends CrmExtTenVo {

    @ApiModelProperty("提交时间")
    private String scoreTime;

    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称")
    private String clientName;

    @ApiModelProperty("客户类型")
    private String clientType;

    @ApiModelProperty("客户类型")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    @ApiModelProperty("协访合格率")
    private String helpVisitPassRate;

    @ApiModelProperty("被协访人员账号")
    private String coverHelpUserName;

    @ApiModelProperty("被协访人员姓名")
    private String coverHelpRealName;

    @ApiModelProperty("被协访人员职位编码")
    private String coverHelpPosCode;

    @ApiModelProperty("被协访人员职位名称")
    private String coverHelpPosName;

    @ApiModelProperty("被协访人员所属组织编码")
    private String coverHelpOrgCode;

    @ApiModelProperty("被协访人员所属组织")
    private String coverHelpOrgName;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("协访人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("协访人员职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("协访人员所属组织")
    private String orgName;

    @ApiModelProperty("评价明细明细")
    private List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList;

}
