package com.biz.crm.visitstep.resp;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/4/6 10:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel("异常提报报表返回")
public class SfaVisitStepAbnormalTableRespVo extends ExtTenVo {
    @ApiModelProperty("客户编码;")
    private String clientCode;

    @ApiModelProperty("客户名称;")
    private String clientName;

    @ApiModelProperty("客户类型;")
    private String clientType;

    @ApiModelProperty("客户类型;")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeDesc;

    @ApiModelProperty("人员账号;")
    private String visitUserName;

    @ApiModelProperty("人员姓名;")
    private String visitRealName;

    @ApiModelProperty("人员职位编码;")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码;")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;")
    private String visitOrgName;

    @ApiModelProperty("人员上级所属组织编码;")
    private String parentOrgCode;

    @ApiModelProperty("人员上级所属组织名称;")
    private String parentOrgName;

    @ApiModelProperty("异常提交时间")
    private String exceptionTime;

    @ApiModelProperty("异常描述")
    private String exceptionDetail;

    @ApiModelProperty("异常照片")
    private List<CrmAttachment> visitExceptionPics;

    private String bizId;
}
