package com.biz.crm.visitstep.resp;

import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepIconRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 *
 * 拜访步骤模块-查询VO
 * @author YuanZiJian
 * @date 2021/2/5 13:52
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤模块-查询")
@SaturnEntity(name = "SfaVisitStepFromModelRespVo", description = "拜访步骤模块-查询")
public class SfaVisitStepFromModelRespVo {
    /**
     * 模块名称
     */
    @ApiModelProperty("模块名称")
    private String modelName;
    /**
     * 模块logo
     */
    @ApiModelProperty("模块logo")
    private List<SfaVisitStepIconRespVo> modelIcon;
    public String getModelIconUrl(){
        if(CollectionUtils.isEmpty(this.modelIcon)){
            return null;
        }
        SfaVisitStepIconRespVo pic = this.modelIcon.get(0);
        return pic.getUrlPathPrefix() + pic.getUrlPath();
    }
    public void setModelIconUrl(String modelIconUrl){

    }
    /**
     * 模块顺序
     */
    @ApiModelProperty("模块顺序")
    private String modelSort;

    /**
     * 拜访步骤控件——新增编辑VoList
     */
    @ApiModelProperty("拜访步骤控件")
    private List<SfaVisitStepFromControlRespVo> sfaVisitStepFromControlRespVoList;
}
