package com.biz.crm.visitstep.resp;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepIconRespVo;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 拜访步骤表单-新增编辑
 * @author YuanZiJian
 * @date 2021/2/5 12:34
 * @version: V1.0
 */
@Data
@ApiModel(value = "拜访步骤表单-查询")
public class SfaVisitStepFromRespVo {

    /**
     *获取 redisHash
     * @return
     */
    public static StringJoiner redisHash(){
        return new StringJoiner(RedisParam.DELIMITER).add(RedisParam.SFA_VISIT).add(SfaVisitStepFromEntity.TABLE_NAME);
    }

    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getId(), this);
        return redisDataForWrite;
    }


    @ApiModelProperty("步骤表单Id")
    private String id;
    @ApiModelProperty("步骤编码")
    private String stepCode;
    /**
     * 步骤表单名称
     */
    @ApiModelProperty("步骤表单名称")
    private String fromName;
    /**
     * 拜访类型
     */
    @ApiModelProperty("拜访类型")
    private String visitType;
    /**
     * 拜访类型名称 查询用！！
     */
    @ApiModelProperty("拜访类型名称——查询用！！")
    @CrmDict(typeCode = "sfaVisitType",dictCodeField = "visitType")
    private String visitTypeName;

    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String customerType;

    /**
     * 客户细类
     */
    @ApiModelProperty("客户细类")
    private String clientSubclass;
    /**
     * 客户类型名称 查询用！！
     */
    @ApiModelProperty("客户类型名称——查询用！！")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "customerType")
    private String customerTypeName;
    /**
     * 有效期类型
     */
    @ApiModelProperty("有效期类型")
    private String timeType;
    /**
     * 有效期类型名称 查询用！！
     */
    @ApiModelProperty("有效期类型——查询用！！")
    @CrmDict(typeCode = "timeType",dictCodeField = "timeType")
    private String timeTypeName;
    /**
     * 有效期开始时间
     */
    @ApiModelProperty("有效期开始时间")
    private String startTime;
    /**
     * 有效期结束时间
     */
    @ApiModelProperty("有效期结束时间")
    private String endTime;
    /**
     * 步骤logo
     */
    @ApiModelProperty("步骤logo")
    private String icon;

    public String getIconUrl(){

        return this.icon;
    }
    public void setIconUrl(String iconUrl){

    }
    /**
     * 页面编码——（模板）
     */
    @ApiModelProperty("页面编码——（即模板）")
    private String pageCode;
    /**
     * 页面编码名称——（模板名称）查询用！！
     */
    @ApiModelProperty("页面编码名称——（模板名称）查询用！！")
    @CrmDict(typeCode = "sfa_visit_step",dictCodeField = "pageCode")
    private String pageCodeName;

    @ApiModelProperty("备注")
    private String remarks;

    /**
     * 是否获取定位信息
     */
    @ApiModelProperty("是否获取定位信息")
    private String locateType;

    /**
     * 距离
     */
    @ApiModelProperty("距离")
    private String distance;

    @ApiModelProperty("是否获取定位信息-名称")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "locateType")
    private String locateTypeName;

    @ApiModelProperty("拜访步骤模块-新增编辑Vo")
    private List<SfaVisitStepFromModelRespVo> stepFromModelRespVoList;

}
