package com.biz.crm.visitstep.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.req.GetActForWorkbenchReq;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;

import java.util.List;

/**
 * 活动执行;接口
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
public interface ISfaVisitStepActivityExecutionService extends IService<SfaVisitStepActivityExecutionEntity> {

    /**
     * 清理明细，单独启动数据库事务
     * @param sfaActivityExecutionEntity
     */
    void cleanExecutionData(SfaActivityExecutionEntity sfaActivityExecutionEntity);

    /**
     * 列表
     * @param sfaVisitStepActivityExecutionReqVo
     * @return PageResult<SfaVisitStepActivityExecutionRespVo>
     */
    PageResult<SfaVisitStepActivityExecutionRespVo> findList(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 通过网点编码获取费用执行完成活动
     * @param sfaVisitStepActivityExecutionReqVo
     * @return
     */
    PageResult<SfaVisitStepActivityExecutionRespVo> findWorkActivityList(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 查询费用活动执行列表
     * @param reqVo
     * @return
     */
    PageResult<SfaActivityExecutionRespVo> findCostActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 工作台-查询可执行活动列表
     * @param reqVo
     * @return
     */
    PageResult<SfaActivityExecutionEntityResp> getActForWorkbench(GetActForWorkbenchReq reqVo);

    List<? extends SfaVisitStepActivityExecutionRedisData> loadVisitActivityList(String visitInfoId, String activityType);
    /**
     * 加载拜访执行活动列表
     * @param reqVo
     * @return
     */
    List<SfaActivityExecutionEntityResp> loadVisitActivityList(LoadVisitActivityListReq reqVo);

    /**
     * 查询
     * @param sfaVisitStepActivityExecutionReqVo
     * @return SfaVisitStepActivityExecutionRespVo
     */
    SfaVisitStepActivityExecutionRespVo query(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 通过活动执行id查询详情
     * @param id
     * @return
     */
    SfaActivityExecutionRespVo queryDetailById(String id);

    /**
     * 查询拜访活动执行详情
     * @param reqVo
     * @return
     */
    SfaActivityExecutionRespVo queryVisitActivityExecutionDetailById(SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 查询费用活动拜访详情信息
     * @return
     */
    SfaActivityExecutionRespVo findVisitCostActivityExecutionByVisitId(String visitId);

    /**
     * 查询陈列活动拜访详情信息
     * @return
     */
    SfaActivityExecutionRespVo findVisitDisplayActivityExecutionByVisitId(String visitId);

    /**
     * 新增
     * @param sfaVisitStepActivityExecutionReqVo
     * @return
     */
    void save(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 拜访执行-活动执行(陈列，费用活动执行)
     * @param reqVo
     */
    void saveVisitActivityExecutionForVisit(SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 工作台新增
     * @param reqVo
     */
    String saveVisitActivityExecutionForWorkbench(SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 更新
     * @param sfaVisitStepActivityExecutionReqVo
     * @return
     */
    void update(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 删除
     * @param sfaVisitStepActivityExecutionReqVo
     * @return
     */
    void deleteBatch(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 启用
     * @param sfaVisitStepActivityExecutionReqVo
     * @return
     */
    void enableBatch(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    /**
     * 禁用
     * @param sfaVisitStepActivityExecutionReqVo
     * @return
     */
    void disableBatch(SfaVisitStepActivityExecutionReqVo sfaVisitStepActivityExecutionReqVo);

    void save(List<? extends SfaVisitStepActivityExecutionEntity> executionEntities);

    /**
     * 陈列拜访任务完成操作
     *
     * @param stepId
     * @param stepCode
     * @param status
     * @param msg
     */
    void finishDisplayVisitStep(String stepId, String stepCode, String status, String msg);

    /**
     *
     */
    void deleteAll();
}

