package com.biz.crm.visitstep.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromSearchReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromToStepSearchReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromToStepRespVo;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;

import java.util.List;

/**
 * 拜访步骤表单
 * @author YuanZiJian
 * @date 2021/2/4 10:56
 * @version: V1.0
 */
public interface ISfaVisitStepFromService extends IService<SfaVisitStepFromEntity> {
    /**
     * 根据名字查询出相关下拉拜访步骤表单数据
     * @method queryListToStep
     * @date: 2021/2/22 15:15
     * @author: YuanZiJian
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromToStepRespVo>
     */
    PageResult<SfaVisitStepFromToStepRespVo> queryListToStep (SfaVisitStepFromToStepSearchReqVo sfaVisitStepFromToStepSearchReqVo);

    /**
     * 根据主键Id查询拜访步骤表单详情
     * @method queryById
     * @date: 2021/2/5 15:16
     * @author: YuanZiJian
     * @param id 拜访步骤保单主键ID
     * @return com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo
     */
    SfaVisitStepFromRespVo queryById(String id);

    /**
     * 拜访步骤表单—— 分页查询步骤表单列表
     * @method queryList
     * @date: 2021/2/5 10:55
     * @author: YuanZiJian
     * @param sfaVisitStepFromSearchReqVo 步骤表单查询Vo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo>
     */
    PageResult<SfaVisitStepFromListRespVo> queryList(SfaVisitStepFromSearchReqVo sfaVisitStepFromSearchReqVo);

    /**
     * 拜访步骤表单—— 新增和编辑
     * @method saveOrUpdate
     * @date: 2021/2/5 12:37
     * @author: YuanZiJian
     * @param sfaVisitStepFromReqVo 接收步骤表单新增修改信息Vo
     * @return void
     */
    void saveOrUpdate(SfaVisitStepFromReqVo sfaVisitStepFromReqVo);

    /**
     * 查询、新增全局表单
     * @method saveOrUpdate
     * @date: 2021/2/5 12:37
     * @author: YuanZiJian
     * @return void
     */
    SfaVisitStepFromRespVo loadOrAddGlobalForm(String pageCode, String stepCode);
    /**
     * 拜访步骤表单—— 删除（批量）——被禁用后的数据才能删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 拜访步骤表单—— 启用（批量)
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 拜访步骤表单—— 禁用（批量)
     * @param ids
     */
    void disableBatch(List<String> ids);
}
