package com.biz.crm.visitstep.service;

import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInStoreReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOutStoreReqVo;
import com.biz.crm.visitstep.model.SfaVisitStepInoutEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepInoutRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInoutReqVo;

import java.util.Map;

/**
 * 拜访步骤(进离店) 接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface ISfaVisitStepInoutService extends IService<SfaVisitStepInoutEntity> {

    /**
     * 列表
     * @param sfaVisitStepInoutReqVo
     * @return PageResult<SfaVisitStepInoutRespVo>
     */
    PageResult<SfaVisitStepInoutRespVo> findList(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 查询
     * @param sfaVisitStepInoutReqVo
     * @return SfaVisitStepInoutRespVo
     */
    SfaVisitStepInoutRespVo query(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 进店操作
     * @param sfaVisitStepInStoreReqVo
     * @return
     */
    void saveInStore(SfaVisitStepInStoreReqVo sfaVisitStepInStoreReqVo);

    /**
     * 离店操作
     * @param sfaVisitStepOutStoreReqVo
     * @return
     */
    void saveOutStore(SfaVisitStepOutStoreReqVo sfaVisitStepOutStoreReqVo);

    /**
     * 删除
     * @param sfaVisitStepInoutReqVo
     * @return
     */
    void deleteBatch(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 启用
     * @param sfaVisitStepInoutReqVo
     * @return
     */
    void enableBatch(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 禁用
     * @param sfaVisitStepInoutReqVo
     * @return
     */
    void disableBatch(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);
}

