package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaLogRecordReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaLogRecordRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaLogRecordMapper;
import com.biz.crm.visitstep.model.SfaLogRecordEntity;
import com.biz.crm.visitstep.service.ISfaLogRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 *
 * 日志接口实现类
 *
 * @Author hej
 * @Created Date 2020-11-25
 **/

@Slf4j
@Service
@Transactional
@ConditionalOnMissingBean(name="sfaLogRecordServiceExpandImpl")
public class SfaLogRecordServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaLogRecordMapper, SfaLogRecordEntity> implements ISfaLogRecordService {

    @Resource
    private SfaLogRecordMapper sfaLogRecordMapper;

    @Override
    public PageResult<SfaLogRecordRespVo> findList(SfaLogRecordReqVo reqVo) {
        checkSave(reqVo);
        Page<SfaLogRecordRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaLogRecordRespVo> list = sfaLogRecordMapper.findList(page,reqVo);
        return PageResult.<SfaLogRecordRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public void save(SfaLogRecordReqVo reqVo) {
        checkSave(reqVo);
        SfaLogRecordEntity copy = CrmBeanUtil.copy(reqVo, SfaLogRecordEntity.class);
        this.save(copy);
    }


    private void checkSave(SfaLogRecordReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getBusinessId(),"业务ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getLogType(),"日志类型不能为空");
    }


}
