package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.activity.mapper.SfaActivityExecutionMapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.ai.util.AiTaskStatusEnums;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum.StepActivityExecuteStatus;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityDisplayStepExecuteDataResp;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionMapper;
import com.biz.crm.visitstep.model.*;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.GetActForWorkbenchReq;
import com.biz.crm.visitstep.req.LoadActivityExecutionListReq;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionTypeService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动执行;接口实现
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepActivityExecutionServiceExpandImpl")
@Transactional
public class SfaVisitStepActivityExecutionServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepActivityExecutionMapper, SfaVisitStepActivityExecutionEntity> implements ISfaVisitStepActivityExecutionService, VisitDataDurabilityService {

    @Resource
    private SfaVisitStepActivityExecutionMapper sfaVisitStepActivityExecutionMapper;
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ISfaVisitStepActivityExecutionTypeService sfaVisitStepActivityExecutionTypeService;
    @Resource
    private ISfaVisitPictureService sfaVisitPictureService;
    @Resource
    private SfaActivityExecutionMapper sfaActivityExecutionMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitStepActivityExecutionServiceEsImpl sfaVisitStepActivityExecutionServiceEsImpl;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;

    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;


    /**
     * 清理明细，单独启动数据库事务
     * @param sfaActivityExecutionEntity
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void cleanExecutionData(SfaActivityExecutionEntity sfaActivityExecutionEntity){
        log.info("cleanExecutionData");
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        LambdaQueryWrapper<SfaVisitStepActivityExecutionEntity> wrapper = Wrappers.lambdaQuery(SfaVisitStepActivityExecutionEntity.class)
                .eq(SfaVisitStepActivityExecutionEntity :: getActivityExecutionId, sfaActivityExecutionEntity.getId())
                .eq(SfaVisitStepActivityExecutionEntity :: getExecuteStatus, SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal());
        if(SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(sfaActivityExecutionEntity.getActivityType())){
            this.sfaVisitStepActivityCostExecutionEsDataRepositories.deleteByActivityExecutionIdAndExecuteStatusAndActivityEndTimeGreaterThanEqual
                    (sfaActivityExecutionEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal(),now);
            this.sfaVisitStepActivityCostExecutionEsDataRepositories.refresh();
            wrapper.ge(SfaVisitStepActivityExecutionEntity::getActivityEndTime,now);
            this.remove(wrapper);
        }else{
            this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.deleteByActivityExecutionIdAndExecuteStatusAndActivityDate
                    (sfaActivityExecutionEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal(),now);
            this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.refresh();
            wrapper.ge(SfaVisitStepActivityExecutionEntity::getActivityDate,now);
            this.remove(wrapper);
            log.info("cleanExecutionData end");
        }
    }
    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepActivityExecutionRespVo> findList(SfaVisitStepActivityExecutionReqVo reqVo) {
        Page<SfaVisitStepActivityExecutionRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepActivityExecutionRespVo> list = sfaVisitStepActivityExecutionMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 通过网点编码获取费用执行完成活动
     *
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaVisitStepActivityExecutionRespVo> findWorkActivityList(SfaVisitStepActivityExecutionReqVo reqVo) {
        String username = UserUtils.getUser().getUsername();
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "网点编码不能为空");
        reqVo.setUserName(username);
        //设置不是拜访
        reqVo.setIsVisit(Integer.valueOf(SfaCommonEnum.whether.NO.getValue()));
        Page<SfaVisitStepActivityExecutionRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepActivityExecutionRespVo> list = sfaVisitStepActivityExecutionMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询费用活动执行列表
     *
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaActivityExecutionRespVo> findCostActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "网点编码为空");
        AssertUtils.isNotEmpty(reqVo.getClientType(), "网点类型为空");
        String userName = UserUtils.getUser().getUsername();
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        //判断是否需要进行去重
        if (SfaCommonEnum.whether.YES.getValue().equals(reqVo.getDoNot())){
            //查询出在活动执行时间中存在已执行活动的客户信息(排除拜访信息)
            List<SfaVisitStepActivityExecutionEntity> stepActivityExecutionEntities = this.lambdaQuery()
                    .eq(SfaVisitStepActivityExecutionEntity::getClientCode, reqVo.getClientCode())
                    .eq(SfaVisitStepActivityExecutionEntity::getUserName, userName)
                    .eq(SfaVisitStepActivityExecutionEntity::getActivityType, SfaActivityEnum.activityType.COST_ACTIVITY.getVal())
                    .le(SfaVisitStepActivityExecutionEntity::getActivityStartTime, now)
                    .ge(SfaVisitStepActivityExecutionEntity::getActivityEndTime, now)
                    .isNull(SfaVisitStepActivityExecutionEntity::getStepCode).list();
            List<String> activityExecutionIds = null;
            if (CollectionUtil.listNotEmptyNotSizeZero(stepActivityExecutionEntities)) {
                activityExecutionIds = stepActivityExecutionEntities.stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toList());
                reqVo.setIds(activityExecutionIds);
            }
        }
        String channelCode = null;
        String orgCode = null;
        //判断是经销商
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(reqVo.getClientType())) {
            MdmCustomerMsgRespVo mdmCustomerMsgRespVo = getMdmCustomerMsgRespVo(reqVo.getClientCode());
            channelCode = mdmCustomerMsgRespVo.getChannel();
            orgCode = mdmCustomerMsgRespVo.getOrgCode();
        } else {
            MdmTerminalVo mdmTerminalVo = getMdmTerminalVo(reqVo.getClientCode());
            channelCode = mdmTerminalVo.getChannel();
            orgCode = mdmTerminalVo.getOrgCode();
        }
        List<String> codeList = new ArrayList<>();
        codeList.add(reqVo.getClientCode());
        if (StringUtils.isNotEmpty(channelCode)) {
            codeList.add(channelCode);
        }
        if (StringUtils.isNotEmpty(orgCode)) {
            codeList.add(orgCode);
        }
        reqVo.setCodeList(codeList);
        Page<SfaActivityExecutionRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActivityExecutionRespVo> list = sfaActivityExecutionMapper.findCostList(page,reqVo);
        return PageResult.<SfaActivityExecutionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 工作台-查询可执行活动列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActivityExecutionEntityResp> getActForWorkbench(GetActForWorkbenchReq reqVo) {
        if(org.apache.commons.lang3.StringUtils.isBlank(reqVo.getStepCode())){
            throw new BusinessException("步骤编码为空！");
        }

        org.springframework.data.domain.Page<? extends SfaVisitStepActivityExecutionRedisData> redisData = this.doLoadActivityExecutionPageList(reqVo);
        List<SfaActivityExecutionEntityResp> result = this.buildDataList(redisData.getContent());
        if (CollectionUtil.listEmpty(result)){
            return PageResult.<SfaActivityExecutionEntityResp>builder()
                    .data(result)
                    .count(redisData.getTotalElements())
                    .build();
        }
        return PageResult.<SfaActivityExecutionEntityResp>builder()
                .data(result)
                .count((long) result.size())
                .build();
    }
    protected org.springframework.data.domain.Page<? extends SfaVisitStepActivityExecutionRedisData> doLoadActivityExecutionPageList(GetActForWorkbenchReq reqVo){
        LoadActivityExecutionListReq listReq = CrmBeanUtil.copy(reqVo, LoadActivityExecutionListReq.class);
        listReq.setPosCode(UserUtils.getUser().getPoscode());
        BoolQueryBuilder baseBuilder = this.buildQueryBuilder(listReq);
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery(baseBuilder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(reqVo.getPageNum() - 1, reqVo.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("activityTime").unmappedType("keyword").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        if(SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(listReq.getActivityType())){
//            SfaVisitStepActivityExecutionEntity
            return this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(query);
        }else {
            return this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(query);
        }
    }

    /**
     * 加载拜访执行活动列表(提交结算)
     * @param visitInfoId
     * @return
     */
    @Override
    public List<? extends SfaVisitStepActivityExecutionRedisData> loadVisitActivityList(String visitInfoId, String activityType) {
        Iterable<? extends SfaVisitStepActivityExecutionRedisData> esData = this.doLoadVisitActivityList(visitInfoId, activityType);
        return Lists.newArrayList(esData);
    }

    /**
     * 加载拜访执行活动列表
     * @param reqVo
     * @return
     */
    @Override
    public List<SfaActivityExecutionEntityResp> loadVisitActivityList(LoadVisitActivityListReq reqVo) {

        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.checkLoadVisitActivityList(reqVo);

        LoadActivityExecutionListReq listReq = CrmBeanUtil.copy(reqVo, LoadActivityExecutionListReq.class);
        listReq.setPosCode(sfaVisitPlanInfoEntity.getVisitPosCode());
        listReq.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        String visitStatus = sfaVisitPlanInfoEntity.getVisitStatus();
        Boolean executed;
        if(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())){
            executed = !(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(visitStatus)
                    || SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(visitStatus));
        }else{
            executed = !(SfaVisitEnum.visitStatus.V1.getVal().equals(visitStatus)
                    || SfaVisitEnum.visitStatus.V2.getVal().equals(visitStatus));
        }

        listReq.setExecuted(executed);
        Iterable<? extends SfaVisitStepActivityExecutionRedisData> esData = this.doLoadActivityExecutionList(listReq);
        return this.buildDataList(esData);
    }

    protected Iterable<? extends SfaVisitStepActivityExecutionRedisData> doLoadActivityExecutionList(LoadActivityExecutionListReq listReq){

        BoolQueryBuilder baseBuilder = this.buildQueryBuilder(listReq);

        if(SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(listReq.getActivityType())){
//            SfaVisitStepActivityExecutionEntity
            return this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(baseBuilder);
        }else {
            return this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(baseBuilder);
        }
    }

    protected Iterable<? extends SfaVisitStepActivityExecutionRedisData> doLoadVisitActivityList(String visitInfoId, String activityType){
        BoolQueryBuilder baseBuilder = QueryBuilders.boolQuery();
        baseBuilder.must(QueryBuilders.termQuery("visitPlanInfoId", visitInfoId));

        if(SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(activityType)){
//            SfaVisitStepActivityExecutionEntity
            return this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(baseBuilder);
        }else {
            return this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(baseBuilder);
        }
    }
    protected void checkLoadActivityExecutionList(LoadActivityExecutionListReq listReq){
        if(org.apache.commons.lang3.StringUtils.isBlank(listReq.getActivityType())){
            throw new BusinessException("活动类型为空！");
        }
        if(org.apache.commons.lang3.StringUtils.isBlank(listReq.getClientCode())){
            throw new BusinessException("客户编码为空！");
        }
        if(org.apache.commons.lang3.StringUtils.isBlank(listReq.getPosCode())){
            throw new BusinessException("职位编码为空！");
        }
    }

    protected BoolQueryBuilder buildQueryBuilder(LoadActivityExecutionListReq listReq){
        this.checkLoadActivityExecutionList(listReq);
        BoolQueryBuilder baseBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        String dateTimeNow = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        Boolean executed = listReq.getExecuted();
        if(null == executed || !executed){
            if(SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(listReq.getActivityType())){
//            SfaVisitStepActivityExecutionEntity
                builder.must(QueryBuilders.rangeQuery("activityStartTime").lte(dateTimeNow));
                builder.must(QueryBuilders.rangeQuery("activityEndTime").gte(dateTimeNow));
            }else {
                builder.must(QueryBuilders.termQuery("activityDate", dateTimeNow));
            }
            BoolQueryBuilder executeStatusBuilderBase = QueryBuilders.boolQuery();
            BoolQueryBuilder executeStatusBuilderWaiting = QueryBuilders.boolQuery();
            executeStatusBuilderWaiting.must(QueryBuilders.termQuery("executeStatus", SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal()));
            BoolQueryBuilder executeStatusBuilderExecuting = QueryBuilders.boolQuery();
            executeStatusBuilderExecuting.must(QueryBuilders.termQuery("executeStatus", SfaActivityEnum.StepActivityExecuteStatus.EXECUTING.getVal()));
            executeStatusBuilderExecuting.must(QueryBuilders.termQuery("posCode.keyword", listReq.getPosCode()));

            BoolQueryBuilder executeStatusBuilderCheckIn = QueryBuilders.boolQuery();
            executeStatusBuilderCheckIn.must(QueryBuilders.termQuery("executeStatus", SfaActivityEnum.StepActivityExecuteStatus.CHECK_IN.getVal()));
            BoolQueryBuilder executeStatusBuilderCheckInFail = QueryBuilders.boolQuery();
            executeStatusBuilderCheckInFail.must(QueryBuilders.termQuery("executeStatus", StepActivityExecuteStatus.CHECK_IN_FAIL.getVal()));
            executeStatusBuilderBase.should(executeStatusBuilderWaiting);
            executeStatusBuilderBase.should(executeStatusBuilderExecuting);
            executeStatusBuilderBase.should(executeStatusBuilderCheckIn);
            executeStatusBuilderBase.should(executeStatusBuilderCheckInFail);
            baseBuilder.must(executeStatusBuilderBase);
        }else{
            builder.must(QueryBuilders.termsQuery("executeStatus", SfaActivityEnum.StepActivityExecuteStatus.COMPLETE.getVal()
                    , SfaActivityEnum.StepActivityExecuteStatus.PAST_DUE.getVal()));
        }

        if(org.apache.commons.lang3.StringUtils.isNotBlank(listReq.getStartActivityStartTime())){
            builder.must(QueryBuilders.rangeQuery("activityStartTime").from(listReq.getStartActivityStartTime()));
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(listReq.getEndActivityStartTime())){
            builder.must(QueryBuilders.rangeQuery("activityStartTime").to(listReq.getEndActivityStartTime()));
        }

        if(org.apache.commons.lang3.StringUtils.isNotBlank(listReq.getStartActivityEndTime())){
            builder.must(QueryBuilders.rangeQuery("activityEndTime").from(listReq.getStartActivityEndTime()));
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(listReq.getEndActivityEndTime())){
            builder.must(QueryBuilders.rangeQuery("activityEndTime").to(listReq.getEndActivityEndTime()));
        }

        if(org.apache.commons.lang3.StringUtils.isNotBlank(listReq.getStartActivityTime())){
            builder.must(QueryBuilders.rangeQuery("activityTime").from(listReq.getStartActivityTime()));
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(listReq.getEndActivityTime())){
            builder.must(QueryBuilders.rangeQuery("activityTime").to(listReq.getEndActivityTime()));
        }

        builder.must(QueryBuilders.termQuery("stepCode", listReq.getStepCode()));
        builder.must(QueryBuilders.termQuery("clientCode.keyword", listReq.getClientCode()));
        baseBuilder.must(builder);



        return baseBuilder;
    }

    protected List<SfaActivityExecutionEntityResp> buildDataList(Iterable<? extends SfaVisitStepActivityExecutionRedisData> esData){
        List<SfaActivityExecutionEntityResp> results = Lists.newArrayList();
        Map<String, String> dict = DictUtil.getDictValueMapsByCodes(SfaActivityEnum.StepActivityExecuteStatus.DICT_CODE);
        esData.forEach(v -> {
            SfaActivityExecutionEntityResp resp = CrmBeanUtil.copy(v, SfaActivityExecutionEntityResp.class);
            resp.setExecuteStatusName(dict.get(resp.getExecuteStatus()));
            results.add(resp);
        });
        return results;
    }








    /**
     * 校验
     * @param reqVo
     * @return
     */
    private SfaVisitPlanInfoEntity checkLoadVisitActivityList(LoadVisitActivityListReq reqVo){

        if(org.apache.commons.lang3.StringUtils.isBlank(reqVo.getActivityType())){
            throw new BusinessException("活动类型为空！");
        }
        if(org.apache.commons.lang3.StringUtils.isBlank(reqVo.getStepCode())){
            throw new BusinessException("步骤编码为空！");
        }
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity;
        if(org.apache.commons.lang3.StringUtils.isBlank(reqVo.getId())){
            if(org.apache.commons.lang3.StringUtils.isBlank(reqVo.getRedisHashKey())){
                throw new BusinessException("RedisHashKey 为空！");
            }
            SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(reqVo.getRedisHashKey());
            String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
            sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService
                    .hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(now, visitRedisHashKey.getVisitBigType()).toString(), reqVo.getRedisHashKey());
            if(null == sfaVisitPlanInfoEntity){
                throw new BusinessException("不存在的拜访任务[" + reqVo.getRedisHashKey() + "]");
            }
        }else{
            sfaVisitPlanInfoEntity = this.sfaVisitPlanInfoServiceEsImpl.findById(reqVo.getId());
            if(null == sfaVisitPlanInfoEntity){
                throw new BusinessException("不存在的拜访任务[" + reqVo.getId() + "]");
            }
        }


        return sfaVisitPlanInfoEntity;
    }




    /**
     * 查询当天执行完成的活动id（ES已经执行完的）
     * @param activityType
     * @param stepCode
     * @param clientCode
     * @return
     */
    private Set<String> executedActivityIdOfCurrentDayFromEs(String activityType, String stepCode, String clientCode){
        //已经执行完的
        Set<String> esHistory;
        if(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal().equals(activityType)){
            esHistory = this.sfaVisitStepActivityExecutionServiceEsImpl
                    .getCompleteDisplayActivityIdsAfterDate(stepCode, clientCode, LocalDate.now());
        }else{
            esHistory = this.sfaVisitStepActivityExecutionServiceEsImpl
                    .getCompleteCostActivityIdsAfterDate(stepCode, clientCode, LocalDate.now());
        }
        return esHistory;
    }
    /**
     * 查询
     *
     * @param reqVo
     * @return sfaVisitStepActivityExecutionRespVo
     */
    @Override
    public SfaVisitStepActivityExecutionRespVo query(SfaVisitStepActivityExecutionReqVo reqVo) {
        return null;
    }

    /**
     * 通过活动执行id查询详情
     *
     * @param id
     * @return
     */
    @Override
    @CrmDictMethod
    public SfaActivityExecutionRespVo queryDetailById(String id) {
        SfaVisitStepActivityExecutionEntity executionEntity = this.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getId, id).one();
        if (executionEntity == null) {
            throw new BusinessException("未查询到活动执行明细数据");
        }
        SfaActivityExecutionRespVo respVo = sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
//        SfaActivityExecutionRespVo respVo = JSONObject.parseObject(executionEntity.getActivityJson()).toJavaObject(SfaActivityExecutionRespVo.class);
        List<SfaVisitStepActivityExecutionTypeEntity> executionTypeEntities = sfaVisitStepActivityExecutionTypeService.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId,executionEntity.getId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(executionTypeEntities)){
            List<SfaVisitStepActivityExecutionTypeRespVo> executionTypeRespVoList = CrmBeanUtil.copyList(executionTypeEntities,SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data->{
                List<SfaVisitPictureEntity> sfaVisitPictureEntityList = sfaVisitPictureService.lambdaQuery()
                        .eq(SfaVisitPictureEntity::getBusinessId,data.getId()).list();
                if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureEntityList)){
                    List<SfaVisitPictureRespVo> pictureRespVos = CrmBeanUtil.copyList(sfaVisitPictureEntityList,SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            respVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
        }
        return respVo;
    }

    @Override
    public SfaActivityExecutionRespVo queryVisitActivityExecutionDetailById(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity executionEntity = this.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, reqVo.getActivityExecutionId())
                .eq(SfaVisitStepActivityExecutionEntity::getStepCode,reqVo.getVisitId()).one();
        SfaActivityExecutionRespVo respVo = null;
        if (executionEntity == null) {
            respVo = sfaActivityExecutionService.queryDetailById(reqVo.getActivityExecutionId());
            if (respVo ==null){
                throw new BusinessException("查询活动执行详情信息为空");
            }
        }else {
            respVo = sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
//            respVo = JSONObject.parseObject(executionEntity.getActivityJson()).toJavaObject(SfaActivityExecutionRespVo.class);
            List<SfaVisitStepActivityExecutionTypeEntity> executionTypeEntities = sfaVisitStepActivityExecutionTypeService.lambdaQuery()
                    .eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, executionEntity.getId()).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(executionTypeEntities)) {
                List<SfaVisitStepActivityExecutionTypeRespVo> executionTypeRespVoList = CrmBeanUtil.copyList(executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
                executionTypeRespVoList.forEach(data -> {
                    List<SfaVisitPictureEntity> sfaVisitPictureEntityList = sfaVisitPictureService.lambdaQuery()
                            .eq(SfaVisitPictureEntity::getBusinessId, data.getId()).list();
                    if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureEntityList)) {
                        List<SfaVisitPictureRespVo> pictureRespVos = CrmBeanUtil.copyList(sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                        data.setPictureList(pictureRespVos);
                    }
                });
                respVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
            }
        }
        return respVo;
    }

    /**
     * 查询费用活动拜访详情
     * @param visitId
     * @return
     */
    @Override
    public SfaActivityExecutionRespVo findVisitCostActivityExecutionByVisitId(String visitId) {
        SfaVisitStepActivityExecutionEntity executionEntity = this.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getActivityType, SfaActivityEnum.activityType.COST_ACTIVITY.getVal())
                .eq(SfaVisitStepActivityExecutionEntity::getStepCode,visitId).one();
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo;
        if (executionEntity == null){
            sfaActivityExecutionRespVo = new SfaActivityExecutionRespVo();
            sfaActivityExecutionRespVo.setStepActivityExecutionTypeList(Lists.newArrayList());
            return sfaActivityExecutionRespVo;
        }
        sfaActivityExecutionRespVo = sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
        sfaActivityExecutionRespVo.setRemarks(executionEntity.getRemarks());
//        SfaActivityExecutionRespVo respVo = JSONObject.parseObject(executionEntity.getActivityJson()).toJavaObject(SfaActivityExecutionRespVo.class);;
        List<SfaVisitStepActivityExecutionTypeEntity> executionTypeEntities = sfaVisitStepActivityExecutionTypeService.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, executionEntity.getId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(executionTypeEntities)) {
            List<SfaVisitStepActivityExecutionTypeRespVo> executionTypeRespVoList = CrmBeanUtil.copyList(executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data -> {
                List<SfaVisitPictureEntity> sfaVisitPictureEntityList = sfaVisitPictureService.lambdaQuery()
                        .eq(SfaVisitPictureEntity::getBusinessId, data.getId()).list();
                if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureEntityList)) {
                    List<SfaVisitPictureRespVo> pictureRespVos = CrmBeanUtil.copyList(sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            sfaActivityExecutionRespVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
        }
        return sfaActivityExecutionRespVo;
    }

    /**
     * 查询陈列活动拜访详情
     * @param visitId
     * @return
     */
    @Override
    public SfaActivityExecutionRespVo findVisitDisplayActivityExecutionByVisitId(String visitId) {
        SfaVisitStepActivityExecutionEntity executionEntity = this.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getActivityType, SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())
                .eq(SfaVisitStepActivityExecutionEntity::getStepCode,visitId).one();
        SfaActivityExecutionRespVo respVo;
        if (executionEntity == null){
            respVo = new SfaActivityExecutionRespVo();
            respVo.setStepActivityExecutionTypeList(Lists.newArrayList());
            return respVo;
        }
        respVo = sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
        respVo.setRemarks(executionEntity.getRemarks());
//        respVo = JSONObject.parseObject(executionEntity.getActivityJson()).toJavaObject(SfaActivityExecutionRespVo.class);;
        List<SfaVisitStepActivityExecutionTypeEntity> executionTypeEntities = sfaVisitStepActivityExecutionTypeService.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, executionEntity.getId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(executionTypeEntities)) {
            List<SfaVisitStepActivityExecutionTypeRespVo> executionTypeRespVoList = CrmBeanUtil.copyList(executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data -> {
                List<SfaVisitPictureEntity> sfaVisitPictureEntityList = sfaVisitPictureService.lambdaQuery()
                        .eq(SfaVisitPictureEntity::getBusinessId, data.getId()).list();
                if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureEntityList)) {
                    List<SfaVisitPictureRespVo> pictureRespVos = CrmBeanUtil.copyList(sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            respVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
        }
        return respVo;
    }


    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity entity = CrmBeanUtil.copy(reqVo, SfaVisitStepActivityExecutionEntity.class);
        this.save(entity);
    }

    /**
     * 拜访执行-活动执行(陈列，费用活动执行)
     *
     * @param reqVo
     */
    @Override
    @Transactional
    public void saveVisitActivityExecutionForVisit(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getVisitId(),"拜访id不能为空");
        //校验参数信息
        this.checkParam(reqVo);
        SfaVisitStepActivityExecutionEntity visitStepActivityExecutionEntity = this.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getStepCode,reqVo.getVisitId())
                .eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId,reqVo.getActivityExecutionId()).one();
        //删除活动执行
        if (null != visitStepActivityExecutionEntity){
            String id = visitStepActivityExecutionEntity.getId();
            this.removeById(id);
            List<SfaVisitStepActivityExecutionTypeEntity> stepActivityExecutionTypeEntities = sfaVisitStepActivityExecutionTypeService.lambdaQuery()
                    .eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId,id).list();
            List<String> stepIds = stepActivityExecutionTypeEntities.stream().map(SfaVisitStepActivityExecutionTypeEntity::getId).collect(Collectors.toList());
            sfaVisitStepActivityExecutionTypeService.removeByIds(stepIds);
            List<SfaVisitPictureEntity> sfaVisitPictureEntities = sfaVisitPictureService.lambdaQuery()
                    .in(SfaVisitPictureEntity::getBusinessId,stepIds).list();
            List<String> picIdList = sfaVisitPictureEntities.stream().map(SfaVisitPictureEntity::getId).collect(Collectors.toList());
            sfaVisitPictureService.removeByIds(picIdList);
        }
        this.saveWorkActivityExecution(reqVo);
    }

    /**
     * 工作台新增-活动执行(陈列，费用活动执行)
     *
     * @param reqVo
     */
    @Override
    @Transactional
    public String saveVisitActivityExecutionForWorkbench(SfaVisitStepActivityExecutionReqVo reqVo) {
        //校验参数信息
        this.checkParam(reqVo);
        return this.saveWorkActivityExecution(reqVo);
    }

    /**
     * 新增活动执行(陈列，费用活动执行)
     * @param reqVo
     * @return
     */
    public String saveWorkActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo){

        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = sfaActivityExecutionService.queryDetailById(reqVo.getActivityExecutionId());
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("未查询到活动执行明细数据");
        }
        List<SfaVisitStepActivityExecutionEntity> lastExecutionEntityList = this.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, reqVo.getActivityExecutionId())
                .orderByDesc(SfaVisitStepActivityExecutionEntity::getCreateDate)
                .orderByDesc(SfaVisitStepActivityExecutionEntity::getCreateDateSecond).list();
        //最近一次的拜访执行记录
        if (!org.springframework.util.CollectionUtils.isEmpty(lastExecutionEntityList)) {
            sfaActivityExecutionRespVo.setLastActivityTime(lastExecutionEntityList.get(0).getActivityTime());
        }
        sfaActivityExecutionRespVo.setClientName(reqVo.getClientName());
//        String activityJson = JSONObject.toJSONString(sfaActivityExecutionRespVo);
        //活动执行时间
        String activityTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        reqVo.setActivityTime(activityTime);
//        reqVo.setActivityJson(activityJson);
        reqVo.setActivityType(sfaActivityExecutionRespVo.getActivityType());
        SfaVisitStepActivityExecutionEntity executionEntity = CrmBeanUtil.copy(reqVo, SfaVisitStepActivityExecutionEntity.class);
        executionEntity.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        executionEntity.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        executionEntity.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        if (sfaActivityExecutionRespVo.getActivityFrequency() != null) {
            executionEntity.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        }
        executionEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        executionEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(executionEntity);
        String stepActivityExecutionId = executionEntity.getId();
        reqVo.getStepActivityExecutionTypeList().forEach(data -> {
            SfaVisitStepActivityExecutionTypeEntity executionTypeEntity = CrmBeanUtil.copy(data, SfaVisitStepActivityExecutionTypeEntity.class);
            executionTypeEntity.setStepActivityExecutionId(stepActivityExecutionId);
            sfaVisitStepActivityExecutionTypeService.save(executionTypeEntity);
            //活动执行类型id
            String businessId = executionTypeEntity.getId();
            List<SfaVisitPictureEntity> pictureEntityList = CrmBeanUtil.copyList(data.getPictureList(), SfaVisitPictureEntity.class);
            pictureEntityList.forEach(pic -> {
                pic.setBusinessId(businessId);
                pic.setVisitId(reqVo.getVisitId());
            });
            sfaVisitPictureService.saveBatch(pictureEntityList);
        });
        String id = executionEntity.getId();
        return id;
    }

    /**
     * 校验参数信息
     *
     * @param reqVo
     */
    private void checkParam(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getActivityExecutionId(), "活动执行id不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "网点编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientName(), "网点名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientId(), "网点id不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientType(), "网点类型不能为空");
        AssertUtils.isNotEmpty(reqVo.getLongitude(), "经度不能为空");
        AssertUtils.isNotEmpty(reqVo.getLatitude(), "纬度不能为空");
//        AssertUtils.isNotEmpty(reqVo.getActivityExecutionAddress(), "活动执行地址不能为空");
        AssertUtils.isNotEmpty(reqVo.getStepActivityExecutionTypeList(), "活动执行类型拍照数据为空");
        reqVo.getStepActivityExecutionTypeList().forEach(data -> {
            AssertUtils.isNotEmpty(data.getActivityRequire(), "活动照片类型为空");
            if (!SfaActivityEnum.activityRequire.GETMAP.containsKey(data.getActivityRequire())) {
                throw new BusinessException("错误的活动照片类型");
            }
            AssertUtils.isNotEmpty(data.getPictureList(), "活动照片为空");
        });
        UserRedis user = UserUtils.getUser();
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List<SfaVisitStepActivityExecutionEntity> sfaVisitStepActivityExecutionEntities = sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        //设置状态为启用
        List<SfaVisitStepActivityExecutionEntity> sfaVisitStepActivityExecutionEntities = sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        //设置状态为禁用
        List<SfaVisitStepActivityExecutionEntity> sfaVisitStepActivityExecutionEntities = sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    /**
     * 获取客户组织、渠道
     */
    private MdmCustomerMsgRespVo getMdmCustomerMsgRespVo(String clientCode) {
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = null;
        Result<MdmCustomerMsgRespVo> mdmCustomerMsgRespVoResult = mdmCustomerMsgFeign.query(null, clientCode);
        if (mdmCustomerMsgRespVoResult.isSuccess() && mdmCustomerMsgRespVoResult.getResult() != null) {
            mdmCustomerMsgRespVo = mdmCustomerMsgRespVoResult.getResult();
        }
        return mdmCustomerMsgRespVo;
    }

    /**
     * 获取终端组织、渠道
     */
    private MdmTerminalVo getMdmTerminalVo(String clientCode) {
        MdmTerminalVo mdmTerminalVo = null;
        Result<MdmTerminalVo> mdmTerminalVoResult = mdmTerminalFeign.query(null, clientCode);
        if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null) {
            mdmTerminalVo = mdmTerminalVoResult.getResult();
        }
        return mdmTerminalVo;
    }

    /**
     * ########## 请务必保证接口的幂等性 ###########
     * 拜访数据持久化
     * @param baseEntity
     * @return
     */
    @Override
    @Transactional
    public  List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if(org.springframework.util.CollectionUtils.isEmpty(baseEntity)){
            return Lists.newArrayList();
        }
        List<SfaVisitStepActivityExecutionEntity> executionEntities = (List<SfaVisitStepActivityExecutionEntity>) baseEntity;
        this.save(executionEntities);
        this.doTransToEs(executionEntities, fromRespVo);
        return baseEntity;
    }


    /**
     * 新增
     *
     * @param executionEntities
     * @return
     */
    @Override
    @Transactional
    public void save(List<? extends SfaVisitStepActivityExecutionEntity> executionEntities) {
        this.saveOrUpdateBatch((Collection<SfaVisitStepActivityExecutionEntity>) executionEntities);
        List<SfaVisitStepActivityExecutionRedisData> redisData = (List<SfaVisitStepActivityExecutionRedisData>)executionEntities;
        this.saveActivityRequire(redisData);

    }

    /**
     * 陈列拜访任务完成操作
     *
     * @param stepId
     * @param stepCode
     * @param status
     * @param msg
     */
    @Override
    @Transactional
    public void finishDisplayVisitStep(String stepId, String stepCode, String status, String msg) {
        String executeStatus = StepActivityExecuteStatus.CHECK_IN_FAIL.getVal();
        if(status.equals(AiTaskStatusEnums.SUCCESS.getValue())){
            executeStatus = StepActivityExecuteStatus.COMPLETE.getVal();
        }
      log.info("\r\n*finishDisplayVisitStep*[{}]\r\n", stepId, stepCode, status, msg);
        this.lambdaUpdate().eq(SfaVisitStepActivityExecutionEntity::getId, stepId)
            .set(SfaVisitStepActivityExecutionEntity::getExecuteStatus, executeStatus)
            .set(SfaVisitStepActivityExecutionEntity::getExecuteMsg, msg)
            .update();

        // 更新es数据状态
        SfaVisitStepActivityExecutionRedisData redisData = null;
        Optional<SfaVisitStepActivityDisplayExecutionEsData> optional = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories
            .findById(stepId);
        if(optional.isPresent()){
            SfaVisitStepActivityDisplayExecutionEsData data = optional.get();
            data.setExecuteStatus(executeStatus);
            data.setExecuteMsg(msg);
            sfaVisitStepActivityDisplayExecutionEsDataRepositories.save(data);
            sfaVisitStepActivityDisplayExecutionEsDataRepositories.refresh();
            redisData = new SfaVisitStepActivityExecutionRedisData();
            BeanUtils.copyProperties(data, redisData);
        }

        // 完成发送积分
        if(AiTaskStatusEnums.SUCCESS.getValue().equals(status) && Objects.nonNull(redisData)) {
            List<AbstractVisitStepListener> listeners = AbstractVisitStepListener.getListeners(stepCode);
            if (org.springframework.util.CollectionUtils.isEmpty(listeners)) {
                return;
            }
            for (AbstractVisitStepListener listener : listeners) {
                if (null == listener) {
                    continue;
                }
                VisitStepListener.VisitStepListenerCommittedEvent committedEvent = new VisitStepListener.VisitStepListenerCommittedEvent();
                committedEvent.setEntities(Lists.newArrayList(redisData));
                listener.committed(committedEvent);
            }
        }
    }

    private void saveActivityRequire(List<SfaVisitStepActivityExecutionRedisData> redisData){

        if(null == redisData){
            return;
        }
        List<SfaAttachmentEntity> attachmentEntities = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionRedisData redisDatum : redisData) {
            if (SfaVisitEnum.VISIT_OFF_LINE.online.equals(redisDatum.getLineType())){
                List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList = redisDatum.getActivityRequireReqVoList();
                String id = redisDatum.getId();
                SfaAttachmentUtil.delByBizIdInBizTypeEnums(Lists.newArrayList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE0
                        , AttachmentBizTypeEnum.ACTIVITY_REQUIRE1, AttachmentBizTypeEnum.ACTIVITY_REQUIRE2), id);
                if(null == activityRequireReqVoList){
                    continue;
                }
                for (ActivityStepExecuteData.ActivityRequireReqVo requireReqVo : activityRequireReqVoList) {
                    AttachmentBizTypeEnum bizType = AttachmentBizTypeEnum.VAL_MAP_ENUM.get(AttachmentBizTypeEnum.ACTIVITY_REQUIRE + requireReqVo.getActivityRequire());
                    attachmentEntities.addAll(SfaAttachmentUtil.build(requireReqVo.getPictureList(), bizType, id));
                }
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(attachmentEntities)){
            SfaAttachmentUtil.insert(attachmentEntities);
        }
    }

    /**
     *
     */
    @Override
    public void deleteAll() {
        baseMapper.deleteAll();
    }

    /**
     *  推送ES
     * @param redisDataList
     */
    protected void doTransToEs(List<? extends SfaVisitStepActivityExecutionEntity> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
        if(org.springframework.util.CollectionUtils.isEmpty(redisDataList)){
            return;
        }
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData) redisDataList.get(0);
        if(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal().equals(redisData.getActivityType())){
            this.transToEsForDisplay(redisDataList, fromRespVo);
        }else{
            this.transToEsForCost(redisDataList, fromRespVo);
        }

    }
    /**
     *  推送ES
     * @param redisDataList
     */
    protected void transToEsForCost(List<? extends SfaVisitStepActivityExecutionEntity> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
//        List<String> activityExecutionIds = redisDataList.stream().map(SfaVisitStepActivityExecutionEntity :: getActivityExecutionId).collect(Collectors.toList());
//        Map<String, SfaVisitStepActivityCostExecutionEsData> historyData = this.sfaVisitStepActivityCostExecutionEsDataRepositories
//                .findByActivityExecutionIdInAndVisitPlanInfoId(activityExecutionIds, visitInfoId)
//                .stream().collect(Collectors.toMap(SfaVisitStepActivityCostExecutionEsData :: getActivityExecutionId, v -> v, (o, o2) -> o2));
        List<SfaVisitStepActivityCostExecutionEsData> esData = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionEntity redisDataTemp : redisDataList) {
            SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData) redisDataTemp;
            SfaVisitStepActivityCostExecutionEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepActivityCostExecutionEsData.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            if(null != fromRespVo){
                dataResp.setSfaVisitStepFrom(fromRespVo);
                dataResp.setFormId(fromRespVo.getId());
                dataResp.setStepCode(fromRespVo.getStepCode());
            }

            if(org.apache.commons.lang3.StringUtils.isBlank(dataResp.getVisitPlanInfoId())){
                dataResp.setVisitPlanInfoId(dataResp.getId());
            }
            esData.add(dataResp);
        }
        if(!putMappingCost){
            this.elasticsearchTemplate.putMapping(SfaVisitStepActivityCostExecutionEsData.class);
            putMappingCost = true;
        }
        this.sfaVisitStepActivityCostExecutionEsDataRepositories.saveAll(esData);
        this.sfaVisitStepActivityCostExecutionEsDataRepositories.refresh();
    }
    private static boolean putMappingCost = false;


    /**
     *  推送ES
     * @param redisDataList
     */
    protected void transToEsForDisplay(List<? extends SfaVisitStepActivityExecutionEntity> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
//        List<String> activityExecutionIds = redisDataList.stream().map(SfaVisitStepActivityExecutionEntity :: getActivityExecutionId).collect(Collectors.toList());
//        Map<String, SfaVisitStepActivityDisplayExecutionEsData> historyData = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories
//                .findByActivityExecutionIdInAndVisitPlanInfoId(activityExecutionIds, visitInfoId)
//                .stream().collect(Collectors.toMap(SfaVisitStepActivityDisplayExecutionEsData :: getActivityExecutionId, v -> v, (o, o2) -> o2));
        List<SfaVisitStepActivityDisplayExecutionEsData> esData = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionEntity redisDataTemp : redisDataList) {
            SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData) redisDataTemp;
            SfaVisitStepActivityDisplayExecutionEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepActivityDisplayExecutionEsData.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            if(null != fromRespVo){
                dataResp.setSfaVisitStepFrom(fromRespVo);
                dataResp.setFormId(fromRespVo.getId());
                dataResp.setStepCode(fromRespVo.getStepCode());
            }

            SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(redisData.getActivityExecutionId());
            dataResp.setDisplayContent(this.buildDisplayContent(sfaActivityExecutionRespVo));
            if(org.apache.commons.lang3.StringUtils.isBlank(dataResp.getVisitPlanInfoId())){
                dataResp.setVisitPlanInfoId(dataResp.getId());
            }
            esData.add(dataResp);
        }

        if(!putMappingDisplay){
            this.elasticsearchTemplate.putMapping(SfaVisitStepActivityDisplayExecutionEsData.class);
            putMappingDisplay = true;
        }
        this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.saveAll(esData);
        this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.refresh();
    }
    private static boolean putMappingDisplay = false;

    /**
     * 加载活动数据
     * @param activityExecutionId
     * @return
     */
    protected SfaActivityExecutionRespVo loadSfaActData(String activityExecutionId){
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = sfaActivityExecutionService.queryDetailById(activityExecutionId);
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("未查询到活动数据");
        }
        return sfaActivityExecutionRespVo;
    }

    /**
     * 陈列要求内容
     * @param sfaActivityExecutionRespVo
     * @return
     */
    private ActivityDisplayStepExecuteDataResp.DisplayContent buildDisplayContent(SfaActivityExecutionRespVo sfaActivityExecutionRespVo){
        ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = new ActivityDisplayStepExecuteDataResp.DisplayContent();
        displayContent.setActivityProductList(sfaActivityExecutionRespVo.getActivityProductList());
        List<SfaVisitPictureRespVo> visitPictureList = sfaActivityExecutionRespVo.getVisitPictureList();
        List<CrmAttachment> pictureList = CrmAttachment.convertVisitPic(visitPictureList);
        displayContent.setPictureList(pictureList);
        return displayContent;
    }

}
