package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤(活动执行);接口实现
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitStepActivityServiceExpandImpl")
public class SfaVisitStepActivityServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepActivityMapper, SfaVisitStepActivityEntity> implements ISfaVisitStepActivityService {

    @Resource
    private SfaVisitStepActivityMapper sfaVisitStepActivityMapper;


    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepActivityRespVo> findList(SfaVisitStepActivityReqVo reqVo){
        Page<SfaVisitStepActivityRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepActivityRespVo> list = sfaVisitStepActivityMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepActivityRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<SfaVisitStepActivityRespVo> getListByVisitCode(String visitCode) {
        //查询启用非删除数据
        QueryWrapper<SfaVisitStepActivityEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne("del_flag",CrmDelFlagEnum.DELETE.getCode());
        List<SfaVisitStepActivityEntity> sfaVisitStepActivityEntities = this.list(queryWrapper);
        return CrmBeanUtil.copyList(sfaVisitStepActivityEntities,SfaVisitStepActivityRespVo.class);
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitStepActivityRespVo
     */
    @Override
    public SfaVisitStepActivityRespVo query(SfaVisitStepActivityReqVo reqVo){
        SfaVisitStepActivityEntity sfaVisitStepActivityEntity = this.getById(reqVo.getId());
        return CrmBeanUtil.copy(sfaVisitStepActivityEntity,SfaVisitStepActivityRespVo.class);
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitStepActivityReqVo reqVo){
        SfaVisitStepActivityEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitStepActivityEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);

    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitStepActivityReqVo reqVo){
        SfaVisitStepActivityEntity entity = this.getById(reqVo.getId());
        entity = CrmBeanUtil.copy(reqVo,SfaVisitStepActivityEntity.class);
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitStepActivityReqVo reqVo){
        List<SfaVisitStepActivityEntity> sfaVisitStepActivityEntities = sfaVisitStepActivityMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepActivityEntities)){
            sfaVisitStepActivityEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitStepActivityReqVo reqVo){
        //设置状态为启用
        List<SfaVisitStepActivityEntity> sfaVisitStepActivityEntities = sfaVisitStepActivityMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepActivityEntities)){
            sfaVisitStepActivityEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitStepActivityReqVo reqVo){
        //设置状态为禁用
        List<SfaVisitStepActivityEntity> sfaVisitStepActivityEntities = sfaVisitStepActivityMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepActivityEntities)){
                sfaVisitStepActivityEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityEntities);
    }
}
