package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaLogTypeEnum;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.tpm.ActivityReleaseNeedEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaLogRecordReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletProductReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReportReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletProductRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.util.*;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletItemMapper;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletMapper;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletProductMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletProductEntity;
import com.biz.crm.visitstep.service.ISfaLogRecordService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletProductService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 *
 * 竞品商品接口实现
 *v
 * @Author hej
 * @Created Date 2020-11-24
 **/
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitStepColletProductServiceExpandImpl")
public class SfaVisitStepColletProductServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepColletProductMapper, SfaVisitStepColletProductEntity> implements ISfaVisitStepColletProductService {


    @Resource
    private SfaVisitStepColletProductMapper sfaVisitStepColletProductMapper;

    @Resource
    private SfaVisitStepColletItemMapper sfaVisitStepColletItemMapper;

    @Resource
    private ISfaLogRecordService sfaLogRecordService;

    @Resource
    private SfaVisitStepColletMapper sfaVisitStepColletMapper;

    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<SfaVisitStepColletProductRespVo> findList(SfaVisitStepColletProductReqVo reqVo) {
        Page<SfaVisitStepColletRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        //未删除
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<SfaVisitStepColletProductRespVo> list = this.sfaVisitStepColletProductMapper.findList(page, reqVo);
        list.forEach(f->f.setEnableValue(CrmEnableStatusEnum.getDesc(f.getEnableStatus())));
        return PageResult.<SfaVisitStepColletProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();}

    @Override
    public PageResult<SfaVisitStepColletProductRespVo> findListProduct(SfaVisitStepColletProductReqVo reqVo) {
        Page<SfaVisitStepColletRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        //未删除并且启用
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<SfaVisitStepColletProductRespVo> list = this.sfaVisitStepColletProductMapper.findListProduct(page, reqVo);
        return PageResult.<SfaVisitStepColletProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<SfaVisitStepColletReportRespVo> findReportFormsList(SfaVisitStepColletReportReqVo reqVo) {
        Page<SfaVisitStepColletReportRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepColletReportRespVo> list = sfaVisitStepColletMapper.findReportList(page, reqVo);
        list.stream().forEach(data->{
            data.setClientTypeDescribe(ActivityReleaseNeedEnum.getStatusName(data.getClientType()));
            data.setCreateDate(data.getCreateDate()+" "+data.getCreateDateSecond());
        });
        return PageResult.<SfaVisitStepColletReportRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public SfaVisitStepColletReportRespVo findReportFormsOne(String id) {
        AssertUtils.isNotEmpty(id,"id不能为空");
        SfaVisitStepColletReportRespVo byId = sfaVisitStepColletMapper.findReportOneById(id);
        if(!Objects.isNull(byId)){
            //竞品集合
            List<SfaVisitStepColletItemRespVo> list = sfaVisitStepColletItemMapper.findListByClientId(id);
            byId.setItemRespVos(list);
            //图片集合
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo();
            pictureReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            pictureReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            pictureReqVo.setBusinessId(id);
            pictureReqVo.setPicType(SfaVisitEnum.visitPicType.CONTEND_COMMODITY_PIC.getVal());
            List<SfaVisitPictureRespVo> pictureList = sfaVisitPictureMapper.findSfaVisitPictureList(pictureReqVo);
            byId.setPictureRespVos(pictureList);
        }
        MdmOrgRespVo result = mdmOrgFeign.getParentOrg(null, byId.getCreateOrgCode()).getResult();
        if (!Objects.isNull(result)){
            byId.setClientArea(result.getOrgName());
        }
        byId.setClientTypeDescribe(ActivityReleaseNeedEnum.getStatusName(byId.getClientType()));
        return byId;
    }


    @Override
    public SfaVisitStepColletProductRespVo query(String id) {
        SfaVisitStepColletProductEntity byId = this.getById(id);
        return CrmBeanUtil.copy(byId,SfaVisitStepColletProductRespVo.class);
    }


    @Override
    public void save(SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        SfaVisitStepColletProductEntity copy = CrmBeanUtil.copy(sfaVisitStepColletProductReqVo, SfaVisitStepColletProductEntity.class);
        //未删除并且启用
        copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        copy.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        //写入商品竞品编码
        copy.setContendProductCode(CodeUtil.generateCode(CodeRuleEnum.SFA_CONTEND_PRODUCT_CODE.getCode()));
        this.save(copy);
    }

    @Override
    public void update(SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        SfaVisitStepColletProductEntity copy = CrmBeanUtil.copy(sfaVisitStepColletProductReqVo, SfaVisitStepColletProductEntity.class);
        //TODO 若不对删除状态做修改 为“” 修改成功后会将其置空（updateById在次字段判空失效）
        copy.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.updateById(copy);
        //写入日志记录
        SfaLogRecordReqVo reqVo = new SfaLogRecordReqVo();
        reqVo.setBusinessId(copy.getId());
        reqVo.setLogType(SfaLogTypeEnum.COMPETE_MERCHANDISE_LOG.getCode());
        this.sfaLogRecordService.save(reqVo);

    }

    @Override
    public void deleteBatch(List<String> ids) {
        List<SfaVisitStepColletProductEntity> sfaVisitStepColletProductEntities = sfaVisitStepColletProductMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitStepColletProductEntities)){
            sfaVisitStepColletProductEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepColletProductEntities);
    }

    @Override
    public void enableBatch(List<String> ids) {
        //启用
        //设置状态为启用
        List<SfaVisitStepColletProductEntity> sfaVisitStepColletProductEntities = sfaVisitStepColletProductMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitStepColletProductEntities)){
            sfaVisitStepColletProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepColletProductEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        List<SfaVisitStepColletProductEntity> sfaVisitStepColletProductEntities = sfaVisitStepColletProductMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitStepColletProductEntities)){
            sfaVisitStepColletProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepColletProductEntities);
    }

    /**
     * 这里手动实现
     * 字符串的模糊比较
     *
     * @method
     * @date: 2020/12/24 14:18
     * @author: YuanZiJian
     * @param strSource 被比较的字段
     * @param condition 比较的条件
     * @return
     */
    private boolean strCompare(String strSource,String condition){
        if(strSource.indexOf(condition)>=0){
            return true;
        }else {
            return false;
        }
    }
}
