package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletMapper;
import com.biz.crm.visitstep.model.*;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepColletItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 拜访步骤(竞品采集);接口实现
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepColletServiceExpandImpl")
public class SfaVisitStepColletServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepColletMapper, SfaVisitStepColletEntity> implements ISfaVisitStepColletService, VisitDataDurabilityService {

    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;
    @Resource
    private ISfaVisitStepColletItemService sfaVisitStepColletItemService;


    /**
     * ########## 请务必保证接口的幂等性 ###########
     * 拜访数据持久化
     * @param baseEntity
     * @return
     */
    @Override
    @Transactional
    public  List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if(CollectionUtils.isEmpty(baseEntity)){
            return Lists.newArrayList();
        }
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)(baseEntity.get(0));
        baseEntity = Lists.newArrayList(this.save(redisData));
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    /**
     * 竞品采集新增
     *
     * @param redisData
     * @return
     */
    @Override
    @Transactional
    public SfaVisitStepColletRedisData save(SfaVisitStepColletRedisData redisData) {
        this.saveOrUpdate(redisData);
        this.sfaVisitStepColletItemService.remove(Wrappers.lambdaQuery(SfaVisitStepColletItemEntity.class)
                .eq(SfaVisitStepColletItemEntity :: getColletId, redisData.getId()));
        //竞品商品清单
        List<CompetitorStepExecuteData.ColletItemReqVo> colletItems = redisData.getSfaVisitStepColletItemReqVos();
        if(!CollectionUtils.isEmpty(colletItems)){
            List<SfaVisitStepColletItemEntity> itemEntities = colletItems.stream().map(v -> {
                SfaVisitStepColletItemEntity copy = CrmBeanUtil.copy(v, SfaVisitStepColletItemEntity.class);
                copy.setColletId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepColletItemService.saveOrUpdateBatch(itemEntities);
        }
        SfaAttachmentUtil.del(AttachmentBizTypeEnum.VISIT_STEP_COLLET, redisData.getId());
        if (SfaVisitEnum.VISIT_OFF_LINE.online.equals(redisData.getLineType())){
            //图片
            List<CrmAttachment> pictureReqVos = redisData.getSfaVisitPictureReqVos();
            SfaAttachmentUtil.insert(pictureReqVos, AttachmentBizTypeEnum.VISIT_STEP_COLLET, redisData.getId());
        }
        return redisData;
    }




    /**
     *  推送ES
     * @param redisData
     */
    protected void doTransToEs(SfaVisitStepColletRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepColletEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepColletEsData.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if(StringUtils.isNotBlank(dataResp.getVisitPlanInfoId())){
            SfaVisitStepColletEsData oldData = this.sfaVisitStepColletEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode());
            if(null != oldData){
                dataResp.setId(oldData.getId());
            }
        }
        this.sfaVisitStepColletEsDataRepositories.save(dataResp);
    }



}
