package com.biz.crm.visitstep.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEsData;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepDefaultEsDataRepositories;
import com.biz.crm.visitstep.req.GetColletPageReq;
import com.biz.crm.visitstep.req.GetDefaultPageReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 竞品采集;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitStepDefaultServiceEsImpl {

    @Resource
    private SfaVisitStepDefaultEsDataRepositories sfaVisitStepDefaultEsDataRepositories;



    /**
     * 查询竞品采集分页
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepDefaultEsData> getWorkbenchDefaultPage(GetDefaultPageReq req){

        //执行,返回包装结果的分页
        org.springframework.data.domain.Page<SfaVisitStepDefaultEsData> list = this.sfaVisitStepDefaultEsDataRepositories.search(req.buildQuery());
        return PageResult.<SfaVisitStepDefaultEsData>builder()
                .data(list.getContent())
                .count(list.getTotalElements())
                .build();

    }



}
