package com.biz.crm.visitstep.service.impl;


import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitHelpScoreReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitHelpScoreRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepHelpScoreMapper;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreDetailEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepHelpScoreEsDataRepositories;
import com.biz.crm.visitstep.req.GetHelpVisitEvaluateTableReq;
import com.biz.crm.visitstep.resp.SfaHelpVisitEvaluateTableRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepHelpScoreDetailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 协访评价明细报表
 *
 * @author yangshan
 * @date 2021年4月22日21:17:56
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepHelpScoreTableEsExpandImpl")
public class SfaVisitStepHelpScoreTableEsImpl{

    @Resource
    private SfaVisitStepHelpScoreEsDataRepositories sfaVisitStepHelpScoreEsDataRepositories;
    @Resource
    private SfaVisitStepHelpScoreMapper sfaVisitStepHelpScoreMapper;
    @Resource
    private ISfaVisitStepHelpScoreDetailService sfaVisitStepHelpScoreDetailService;

    public PageResult<SfaHelpVisitEvaluateTableRespVo> getHelpVisitEvaluateTableResult(GetHelpVisitEvaluateTableReq req){

        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaVisitHelpScoreRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        List<SfaVisitHelpScoreRespVo> list = this.sfaVisitStepHelpScoreMapper.findList(page, CrmBeanUtil.copy(req, SfaVisitHelpScoreReqVo.class));
        List<SfaHelpVisitEvaluateTableRespVo> respVos = CrmBeanUtil.copyList(list, SfaHelpVisitEvaluateTableRespVo.class);
        if (CollectionUtil.listNotEmptyNotSizeZero(respVos)){
            List<String> idList = respVos.stream().map(SfaHelpVisitEvaluateTableRespVo::getId).collect(Collectors.toList());
            List<SfaVisitStepHelpScoreDetailEntity> helpScoreDetailList = this.sfaVisitStepHelpScoreDetailService.lambdaQuery()
                    .in(SfaVisitStepHelpScoreDetailEntity::getHelpScoreId, idList)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(helpScoreDetailList)){
                Map<String, List<SfaVisitStepHelpScoreDetailEntity>> map = helpScoreDetailList.stream().collect(Collectors.groupingBy(SfaVisitStepHelpScoreDetailEntity::getHelpScoreId));
                respVos.forEach(r -> r.setHelpScoreDetailList(CrmBeanUtil.copyList(map.get(r.getId()), HelpScoreStepExecuteData.HelpScoreDetailReqVo.class)));
            }

            respVos.forEach(o -> {
                List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetails = o.getHelpScoreDetailList();
                if (CollectionUtil.listEmpty(helpScoreDetails)){
                    o.setHelpVisitPassRate(BigDecimal.ZERO.toString());
                }
                //步骤总数
                long stepCodeNum = helpScoreDetails.stream().map(HelpScoreStepExecuteData.HelpScoreDetailReqVo::getStepCode).count();
                //合格数
                long passNum = helpScoreDetails.stream().filter(h -> YesNoEnum.yesNoEnum.ONE.getValue().equals(h.getQualified())).count();
                //合格率
                BigDecimal passRate = BigDecimal.ZERO;
                if (stepCodeNum > 0){
                    passRate = BigDecimal.valueOf(passNum).divide(BigDecimal.valueOf(stepCodeNum),2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                }
                o.setHelpVisitPassRate(passRate.toString());
            });
        }
        return PageResult.<SfaHelpVisitEvaluateTableRespVo>builder()
                .data(respVos)
                .count(page.getTotal())
                .build();

    }
}
