package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderDetailReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderStockAnalysisReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.*;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderFormMapper;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderFormService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ren.gang
 * @ClassName SfaVisitStepOrderFormServiceImpl.java
 * @Description web端-订单管理-报表接口
 * @createTime 2021年01月12日 14:32:00
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitStepOrderFormServiceExpandImpl")
public class SfaVisitStepOrderFormServiceImpl<M extends BaseMapper<T>, T> implements ISfaVisitStepOrderFormService {

    @Resource
    private SfaVisitStepOrderFormMapper mapper;
    @Autowired
    private ISfaVisitStepOrderItemService orderItemService;


    /**
     * 订单明细
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepOrderDetailRespVo> orderDetail(SfaVisitStepOrderDetailReqVo reqVo) {
        Page<SfaVisitStepOrderDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepOrderDetailRespVo> list = mapper.orderDetail(page, reqVo);
        this.translateCode(list);
        return PageResult.<SfaVisitStepOrderDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 订单明细
     * @param id
     * @return
     */
    @Override
    @CrmAPIDiscard
    @Deprecated
    public SfaVisitStepOrderDetailRespVo orderInfo(String id) {
        List<SfaVisitStepOrderDetailRespVo> list = mapper.orderDetail(null, new SfaVisitStepOrderDetailReqVo(){{setId(id);}});
        this.translateCode(list);
        if(list == null || list.size() == 0) {
            throw new BusinessException("订单明细id错误！");
        }
        SfaVisitStepOrderDetailRespVo respVo = list.get(0);
//        List<SfaVisitStepOrderItemRespVo> itemList = orderItemService.findList(respVo.getId());
//        this.translateUnit(itemList);
//        respVo.setSfaVisitStepOrderItemRespVos(itemList);
        return respVo;
    }

    /**
     * 订单明细(方案活动)
     */
    @Override
    @CrmAPIDiscard
    @Deprecated
    public SfaVisitStepOrderDetailProRespVo orderInfoProgramme(String id){
        List<SfaVisitStepOrderDetailRespVo> list = mapper.orderDetail(null, new SfaVisitStepOrderDetailReqVo(){{setId(id);}});
        this.translateCode(list);
        if(list == null || list.size() == 0) {
            throw new BusinessException("订单明细id错误！");
        }
        List<SfaVisitStepOrderDetailProRespVo> proRespVos = CrmBeanUtil.copyList(list, SfaVisitStepOrderDetailProRespVo.class);
        SfaVisitStepOrderDetailProRespVo respVo = proRespVos.get(0);
        //查询详情
//        List<SfaVisitStepOrderItemRespVo> itemList = orderItemService.findList(respVo.getId());
        //过滤套餐为空的舍弃
//        List<SfaVisitStepOrderItemRespVo> filterList = itemList.stream().filter(date -> StringUtils.isNotEmpty(date.getSetMeal())).collect(Collectors.toList());
        //按套餐分组
//        Map<String, List<SfaVisitStepOrderItemRespVo>> collect = filterList.stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemRespVo::getSetMeal, Collectors.toList()));

        List<SfaVisitStepOrderItemProRespVo> sfaVisitStepOrderItemProRespVos = new ArrayList<>();

//        for (Map.Entry<String, List<SfaVisitStepOrderItemRespVo>> map:collect.entrySet()){
//            SfaVisitStepOrderItemProRespVo sfaVisitStepOrderItemProRespVo = new SfaVisitStepOrderItemProRespVo();
//            String setMeal = map.getKey();
//            List<SfaVisitStepOrderItemRespVo> voList = map.getValue();
//            sfaVisitStepOrderItemProRespVo.setSetMeal(setMeal);
//            Map<String, List<SfaVisitStepOrderItemRespVo>> proMap =
//                    voList.stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemRespVo::getProductType, Collectors.toList()));
//            List<SfaVisitStepOrderItemRespVo> bpVos = proMap.get(SfaActivityEnum.bpItemType.bp.getVal());
//            this.translateUnit(bpVos);
//            List<SfaVisitStepOrderItemRespVo> zpVos = proMap.get(SfaActivityEnum.bpItemType.zp.getVal());
//            this.translateUnit(zpVos);
//            sfaVisitStepOrderItemProRespVo.setBpVos(bpVos);
//            sfaVisitStepOrderItemProRespVo.setZpVos(zpVos);
//            sfaVisitStepOrderItemProRespVos.add(sfaVisitStepOrderItemProRespVo);
//        }
        respVo.setProRespVos(sfaVisitStepOrderItemProRespVos);
        return respVo;
    }

    /**
     * 终端进货量分析
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepOrderStockAnalysisRespVo> stockAnalysis(SfaVisitStepOrderStockAnalysisReqVo reqVo) {
        Page<SfaVisitStepOrderStockAnalysisRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepOrderStockAnalysisRespVo> list = mapper.stockAnalysis(page, reqVo);
        return PageResult.<SfaVisitStepOrderStockAnalysisRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 翻译
     */
    public void translateCode(List<SfaVisitStepOrderDetailRespVo> list){
        Map<String, String> orderType = DictUtil.getDictValueMapsByCodes("sfa_order_source");
        Map<String, String> approalType = DictUtil.getDictValueMapsByCodes("sfa_approval");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)){
            list.forEach(data->{
                if (StringUtils.isNotEmpty(data.getOrderSource())){
                    data.setOrderSourceName(orderType.get(data.getOrderSource()));
                }
                if (StringUtils.isNotEmpty(data.getApprovalStatus())){
                    data.setApprovalStatusName(approalType.get(data.getApprovalStatus()));
                }
            });
        }
    }

    /**
     * 详情单位名称翻译
     */
    public void translateUnit(List<SfaVisitStepOrderItemRespVo> list){
        Map<String, String> unitName = DictUtil.getDictValueMapsByCodes("product_sale_unit");
        Map<String, String> typeName = DictUtil.getDictValueMapsByCodes("sfa_product_type");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)){
            list.forEach(data->{
                if (StringUtils.isNotEmpty(data.getUnit())){
                    data.setUnitName(unitName.get(data.getUnit()));
                }
                if (StringUtils.isNotEmpty(data.getProductType())){
                    data.setProductTypeName(typeName.get(data.getProductType()));
                }
            });
        }

    }

}
