package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderTableRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEsData;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.req.GetOrderPageReq;
import com.biz.crm.visitstep.req.GetOrderPageTableReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 订单采集;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitStepOrderServiceEsImpl {

    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
    @Resource
    private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;



    /**
     * 查询订单采集分页
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepOrderRespVo> getWorkbenchOrderPage(GetOrderPageReq req){

        if(StringUtils.isBlank(req.getPosCode()) && StringUtils.isBlank(req.getPosName())){
            req.setPosCode(UserUtils.getUser().getPoscode());
        }
        //执行,返回包装结果的分页
        org.springframework.data.domain.Page<SfaVisitStepOrderEsData> list = this.sfaVisitStepOrderEsDataRepositories.search(req.buildQuery());
        List<SfaVisitStepOrderRespVo> resultData = list.stream().map(v -> {
            SfaVisitStepOrderRespVo respVo = CrmBeanUtil.copy(v, SfaVisitStepOrderRespVo.class);
            List<OrderAsDataReq.OrderItemAsReqVo> sfaVisitStepOrderItems = v.getSfaVisitStepOrderItems();
            BigDecimal priceTotal = BigDecimal.ZERO;
            BigDecimal quantityTotal = BigDecimal.ZERO;
            if(null != sfaVisitStepOrderItems){
                for (OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
                    quantityTotal = quantityTotal.add(null == sfaVisitStepOrderItem.getQuantity() ? BigDecimal.ZERO : sfaVisitStepOrderItem.getQuantity());
                    priceTotal = priceTotal.add(null == sfaVisitStepOrderItem.getPrice() ? BigDecimal.ZERO : sfaVisitStepOrderItem.getPrice());
                }
                OrderStepExecuteData.OrderItemReqVo temp = sfaVisitStepOrderItems.get(0);
                respVo.setProductName(temp.getProductName());
                respVo.setProductCode(temp.getProductCode());
                respVo.setSeriesCode(temp.getSeriesCode());
                respVo.setSeriesName(temp.getSeriesName());
                respVo.setPicUrl(temp.getPicUrl());
            }
            respVo.setTotalPrice(priceTotal);
            respVo.setQuantity(quantityTotal);
            return respVo;
        }).collect(Collectors.toList());
        return PageResult.<SfaVisitStepOrderRespVo>builder()
                .data(resultData)
                .count(list.getTotalElements())
                .build();

    }

    /**
     * 查询订单报表
     * @param req
     * @return
     */
    @EsDataPermission(userName = "userName.keyword", position = "posCode.keyword", org = "orgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitStepOrderTableRespVo> getOrderTable(GetOrderPageTableReq req){

//        //执行,返回包装结果的分页
//        org.springframework.data.domain.Page<SfaVisitStepOrderEsData> list = this.sfaVisitStepOrderEsDataRepositories.search(req.buildQuery());
//        List<SfaVisitStepOrderTableRespVo> respVos = CrmBeanUtil.copyList(list.getContent(), SfaVisitStepOrderTableRespVo.class);
        Page<SfaVisitStepOrderRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        SfaVisitStepOrderReqVo reqVo = CrmBeanUtil.copy(req, SfaVisitStepOrderReqVo.class);
        reqVo.setStartOrderTime(req.getStartDate());
        reqVo.setEndOrderTime(req.getEndDate());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findOrderReportList(page, reqVo);
        return PageResult.<SfaVisitStepOrderTableRespVo>builder()
                .data(CrmBeanUtil.copyList(list, SfaVisitStepOrderTableRespVo.class))
                .count(page.getTotal())
                .build();
    }
}
