package com.biz.crm.visitstepbase;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitstepbase
 * @date 2021/6/15 11:19
 */
@Slf4j
public class VisitBaseCheck {


    public static void checkBaseData(VisitBaseVo vo) {
        AssertUtils.isNotEmpty(vo.getRedisHashKey(), "redisHashKey为空");
        AssertUtils.isNotEmpty(vo.getFormId(), "表单id为空");
        if (vo.getStepExecuteData() == null) {
            throw new BusinessException("执行数据为空");
        }
        return;
    }

    /**
     * 拜访步骤距离限制
     * @param entity
     * @param stepFromVo
     */
    public static void checkVisitStepDistance(SfaVisitPlanInfoEntity entity, SfaVisitStepFromRespVo stepFromVo, String longitude,String latitude){
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
            if (stepFromVo != null && stepFromVo.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
                if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromVo.getDistance())) {

                    if (StringUtils.isBlank(longitude)) {
                        throw new BusinessException("经度为空");
                    }
                    if (StringUtils.isBlank(latitude)) {
                        throw new BusinessException("纬度为空");
                    }
                    BigDecimal distance = new BigDecimal(stepFromVo.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前步骤配置的距离:{}",distance);
                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}",longitude,latitude,entity.getLongitude(),entity.getLatitude());
                    double data = LocationUtils.getDistance(new BigDecimal(longitude),
                            new BigDecimal(latitude), entity.getLongitude(), entity.getLatitude());
                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前位置距离拜访客户的距离:{}",nowDistance);
                    if (distance.compareTo(nowDistance) == -1) {
                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
                    }
                }
            }
        }
    }

}
