package com.biz.crm.visitstepdetail.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.req.GetStockInventoryPageReq;
import com.biz.crm.visitstep.req.GetStockInventoryTableReq;
import com.biz.crm.visitstepdetail.model.resp.SfaVisitStepStockInventoryTableDetailRespVo;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 拜访步骤(库存盘点);
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepstockinventory")
@Api(tags = "拜访步骤(库存盘点);")
public class SfaVisitStepStockInventoryController {
    @Resource
    private SfaVisitStepStockInventoryServiceEsImpl sfaVisitStepStockInventoryServiceEs;

    /**
     * 查询库存明细报表
     *
     * @param req
     * @return
     */
    @CrmLog
    @ApiOperation(value = "查询库存明细报表")
    @PostMapping("findStockInventoryReportList")
    public Result<PageResult<SfaVisitStepStockInventoryRespVo>> findStockInventoryReportList(@RequestBody GetStockInventoryTableReq req) {
        PageResult<SfaVisitStepStockInventoryRespVo> stockInventoryReportList = sfaVisitStepStockInventoryServiceEs.findStockInventoryReportList(req);
        return Result.ok(stockInventoryReportList);
    }


    /**
     * 查询库存明细报表详细信息
     * @param req
     * @return
     */
    @CrmLog
    @PostMapping("queryStockInventoryReportDetail")
    @ApiOperation(value = "查询库存明细报表详细信息")
    @CrmDictMethod
    public Result<PageResult<SfaVisitStepStockInventoryTableDetailRespVo>> queryStockInventoryReportDetail(@RequestBody GetStockInventoryPageReq req){
        PageResult<SfaVisitStepStockInventoryTableDetailRespVo> respVo = sfaVisitStepStockInventoryServiceEs.findStockInventoryReportDetail(req);
        return Result.ok(respVo);
    }






}
