package com.biz.crm.visitstepdetail.model;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 拜访步骤(库存盘点);实体类
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Getter
@Setter
public class SfaVisitStepStockInventoryRedisData extends SfaVisitStepStockInventoryEntity {

    public static SfaVisitStepStockInventoryRedisData getInstance(){
        return SfaVisitStepStockInventoryRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitStepStockInventoryRedisData instance = new SfaVisitStepStockInventoryRedisData();
    }
    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(stepCode);
    }

    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    @ApiModelProperty("库存盘点明细")
    private List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList;


}
