package com.biz.crm.visitstepdetail.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockDetailMapper;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockInventoryMapper;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockDetailEntity;
import com.biz.crm.visitstepdetail.model.resp.SfaVisitStepStockInventoryTableDetailRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.req.GetStockInventoryPageReq;
import com.biz.crm.visitstep.req.GetStockInventoryTableReq;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockDetailService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 库存盘点;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitStepStockInventoryServiceEsImpl {

    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private SfaVisitStepStockInventoryMapper sfaVisitStepStockInventoryMapper;
    @Resource
    private ISfaVisitStepStockDetailService sfaVisitStepStockDetailService;


    /**
     * 查询库存盘点分页
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepStockInventoryRespVo> getWorkbenchStockInventoryPage(GetStockInventoryPageReq req){

        //执行,返回包装结果的分页
//        org.springframework.data.domain.Page<SfaVisitStepStockInventoryEsData> list = this.sfaVisitStepStockInventoryEsDataRepositories.search(req.buildQuery());
        Page<SfaVisitStepStockInventoryRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportListByClientCode(page, req.getClientCode());
        return PageResult.<SfaVisitStepStockInventoryRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();

    }


    /**
     * 获取给定时间最近一次盘点记录
     * @param stepCode
     * @param clientCode
     * @param stockTime
     * @return
     */
    public SfaVisitStepStockInventoryEsData getLastTimeRecord(String stepCode, String clientCode, LocalDateTime stockTime, String currentId){
        if(StringUtils.isBlank(stepCode)){
            throw new BusinessException("请指定步骤编码");
        }

        if(StringUtils.isBlank(clientCode)){
            throw new BusinessException("请指定客户编码");
        }
        if(null == stockTime){
            throw new BusinessException("请指定执行时间");
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();

        builder.must(QueryBuilders.termQuery("stepCode.keyword", stepCode));
        builder.must(QueryBuilders.termQuery("clientCode.keyword", clientCode));

        builder.must(QueryBuilders.rangeQuery("stockTime").lte(stockTime.format(CrmDateUtils.yyyyMMddHHmmss)));
//        builder.must(QueryBuilders.spanNotQuery(QueryBuilders.spanTermQuery("id.keyword", currentId), QueryBuilders.spanTermQuery("id.keyword", currentId)));

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(0, 2));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("stockTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        List<SfaVisitStepStockInventoryEsData> list = this.sfaVisitStepStockInventoryEsDataRepositories.search(query).getContent();
        if(list.size() > 0){
            SfaVisitStepStockInventoryEsData dataCurrent = list.get(0);
            SfaVisitStepStockInventoryEsData data = list.size() > 1 ? list.get(1) : null;
            if(dataCurrent.getId().equals(currentId)){
                return data;
            }
            return dataCurrent;
        }
        return null;

    }


    protected SearchRequest buildQuery(GetStockInventoryTableReq req){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if(StringUtils.isBlank(req.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }
        builder.must(QueryBuilders.termQuery("stepCode.keyword", req.getStepCode()));

        if (StringUtils.isNotEmpty(req.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", req.getClientCode()));
        }
        if (StringUtils.isNotEmpty(req.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", req.getClientName()));
        }
        if (StringUtils.isNotEmpty(req.getClientType())){
            builder.must(QueryBuilders.termQuery("clientType.keyword", req.getClientType()));
        }
        if (StringUtils.isNotEmpty(req.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", req.getRealName()));
        }
        if (StringUtils.isNotEmpty(req.getProductCode())){
            builder.must(QueryBuilders.termQuery("productCode.keyword", req.getProductCode()));
        }
        if (StringUtils.isNotEmpty(req.getProductName())){
            builder.must(QueryBuilders.matchPhraseQuery("productName", req.getProductName()));
        }
        if (StringUtils.isNotEmpty(req.getStockTime())){
            builder.must(QueryBuilders.matchPhraseQuery("stockTime", req.getStockTime()));
        }
        if (StringUtils.isNotEmpty(req.getUserName())){
            builder.must(QueryBuilders.termQuery("userName", req.getUserName()));
        }

        SearchRequest searchRequest = new SearchRequest("sfa_visit_step_stock_inventory_es_data");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must(builder);
        //聚合
        searchSourceBuilder.collapse(new CollapseBuilder("clientCode.keyword"));
        searchSourceBuilder.aggregation(AggregationBuilders.cardinality("count").field("clientCode.keyword"));
        searchSourceBuilder.from(req.getPageNum() - 1);
        searchSourceBuilder.size(req.getPageSize());
        searchSourceBuilder.query(boolQueryBuilder);
        searchSourceBuilder.sort(SortBuilders.fieldSort("stockTime").order(SortOrder.DESC));
        searchRequest.source(searchSourceBuilder);

        return searchRequest;
    }

    /**
     * 获取total
     */
    protected Long getTotal(SearchResponse searchResponse){
        Aggregation agg = searchResponse.getAggregations().get("count");
        Map map = JSON.parseObject(JSON.toJSONString(agg), Map.class);
        if (null == map){
            return 0L;
        }
        Integer value = (Integer)map.get("value");
        return Long.valueOf(value);
    }

    /**
     * 查询库存明细报表
     * ES聚合查询
     * @param req
     * @return
     */
    @EsDataPermission(userName = "userName.keyword", position = "posCode.keyword", org = "orgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitStepStockInventoryRespVo> findStockInventoryReportList(GetStockInventoryTableReq req) {

//        SearchRequest searchRequest = this.buildQuery(req);
//        List<SfaVisitStepStockInventoryRespVo> result = new ArrayList<>();
//        Long count = 0L;
//        try {
//            SearchResponse searchResponse = elasticsearchTemplate.getClient().search(searchRequest).get();
//            SearchHit[] hits = searchResponse.getHits().getHits();
//            if (null == hits){
//                return PageResult.<SfaVisitStepStockInventoryRespVo>builder()
//                    .data(Lists.newArrayList())
//                    .count(0L)
//                    .build();
//            }
//            count = this.getTotal(searchResponse);
//            for (SearchHit hit : hits) {
//                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
//                if (sourceAsMap != null) {
//                    //map转对象
//                    SfaVisitStepStockInventoryRespVo respVo = JSON.parseObject(JSON.toJSONString(sourceAsMap), SfaVisitStepStockInventoryRespVo.class);
//                    result.add(respVo);
//                }
//            }
//
//        }catch (Exception e){
//            log.info(e.getMessage());
//        }

        Page<SfaVisitStepStockInventoryRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportList(page, req);
        return PageResult.<SfaVisitStepStockInventoryRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 处理数据
     */
    private SfaVisitStepStockInventoryRespVo countData(SfaVisitStepStockInventoryEsData req, String stepCode){

        SfaVisitStepStockInventoryRespVo sfaVisitStepStockInventoryRespVo = CrmBeanUtil.copy(req,SfaVisitStepStockInventoryRespVo.class);
//        List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList = req.getVisitStepStockList();
//        //库存数量
//        SfaVisitStepStockInventoryTableDetailRespVo thisNum = this.getStockDetailNum(visitStepStockList);
//        Integer stockNum = thisNum.getStockNum();
//        sfaVisitStepStockInventoryRespVo.setStockNum(stockNum);
//        //上次库存数量初始值
//        Integer lastStockNum = stockNum;
        //上次盘点时间初始值
        sfaVisitStepStockInventoryRespVo.setLastStockTime(req.getLastTime());

//        //根据clientCode,lastStockTime查询盘库记录
//        if (StringUtils.isNotEmpty(req.getLastTime())){
//            GetStockInventoryTableReq inventoryTableReq = new GetStockInventoryTableReq();
//            inventoryTableReq.setClientCode(req.getClientCode());
//            inventoryTableReq.setStepCode(stepCode);
//            inventoryTableReq.setStockTime(req.getLastTime());
//            Iterable<SfaVisitStepStockInventoryEsData> list = this.sfaVisitStepStockInventoryEsDataRepositories.search(inventoryTableReq.buildQuery());
//            List<SfaVisitStepStockInventoryEsData> lastStockDetail = Lists.newArrayList(list);
//            if (CollectionUtil.listNotEmpty(lastStockDetail)){
//                SfaVisitStepStockInventoryEsData inventoryEsData = lastStockDetail.get(0);
//                //上次盘点时间
//                sfaVisitStepStockInventoryRespVo.setLastStockTime(inventoryEsData.getStockTime());
//                List<StockInventoryStepExecuteData.StockDetailReqVo> stockList = inventoryEsData.getVisitStepStockList();
//                //上次库存数量
//                SfaVisitStepStockInventoryTableDetailRespVo lastNum = this.getStockDetailNum(stockList);
//                lastStockNum = lastNum.getStockNum();
//            }
//        }
//        //上次库存数量
//        sfaVisitStepStockInventoryRespVo.setLastStockNum(lastStockNum);
//        //库存差
//        sfaVisitStepStockInventoryRespVo.setStockDiffer(stockNum - lastStockNum);

        return sfaVisitStepStockInventoryRespVo;
    }

    /**
     * 计算数量
     */
    private SfaVisitStepStockInventoryTableDetailRespVo getStockDetailNum(List<StockInventoryStepExecuteData.StockDetailReqVo> stockList){
        //库存数量
        int stockNum = 0;
        //商品种类数量
        long typeNum = 0L;
        //系列数量
        long seriesNum = 0L;
        if (CollectionUtil.listNotEmpty(stockList)){

            stockNum = stockList.stream().mapToInt(StockInventoryStepExecuteData.StockDetailReqVo::getQuantity).sum();
            typeNum = stockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductCode).count();
            seriesNum = stockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductLevelCode).count();
        }
        SfaVisitStepStockInventoryTableDetailRespVo respVo = new SfaVisitStepStockInventoryTableDetailRespVo();
        respVo.setStockNum(stockNum)
                .setTypeNum(String.valueOf(typeNum))
                .setSeriesNum(String.valueOf(seriesNum));
        return respVo;
    }


    /**
     * 查询库存明细报表详细
     *
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepStockInventoryTableDetailRespVo> findStockInventoryReportDetail(GetStockInventoryPageReq req) {
//        org.springframework.data.domain.Page<SfaVisitStepStockInventoryEsData> list = this.sfaVisitStepStockInventoryEsDataRepositories.search(req.buildQuery());
//        List<SfaVisitStepStockInventoryEsData> listContent = list.getContent();
//        if (CollectionUtil.listEmpty(listContent)){
//            return null;
//        }
//        List<SfaVisitStepStockInventoryTableDetailRespVo> sfaVisitStepStockInventoryTableDetailRespVos = CrmBeanUtil.copyList(listContent, SfaVisitStepStockInventoryTableDetailRespVo.class);
//        sfaVisitStepStockInventoryTableDetailRespVos.forEach(o -> {
//            SfaVisitStepStockInventoryTableDetailRespVo stockDetailNum = this.getStockDetailNum(o.getVisitStepStockList());
//            o.setStockNum(stockDetailNum.getStockNum());
//            o.setTypeNum(String.valueOf(stockDetailNum.getTypeNum()));
//            o.setSeriesNum(String.valueOf(stockDetailNum.getSeriesNum()));
//        });
//
//        return PageResult.<SfaVisitStepStockInventoryTableDetailRespVo>builder()
//                .data(sfaVisitStepStockInventoryTableDetailRespVos)
//                .count(list.getTotalElements())
//                .build();

        if(StringUtils.isBlank(req.getClientCode())){
            throw new BusinessException("客户编码为空");
        }
        Page<SfaVisitStepStockInventoryRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportListByClientCode(page, req.getClientCode());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)){
            List<SfaVisitStepStockInventoryTableDetailRespVo> result = CrmBeanUtil.copyList(list, SfaVisitStepStockInventoryTableDetailRespVo.class);
            List<String> idList = list.stream().map(SfaVisitStepStockInventoryRespVo::getId).collect(Collectors.toList());
            //封装盘库明细
            List<SfaVisitStepStockDetailEntity> detailEntityList = this.sfaVisitStepStockDetailService.lambdaQuery()
                    .in(SfaVisitStepStockDetailEntity::getStockInventoryId, idList)
                    .list();

            if (CollectionUtil.listNotEmptyNotSizeZero(detailEntityList)){
                Map<String, List<SfaVisitStepStockDetailEntity>> map = detailEntityList.stream().collect(Collectors.groupingBy(SfaVisitStepStockDetailEntity::getStockInventoryId));
                result.forEach(o -> {
                    o.setVisitStepStockList(CrmBeanUtil.copyList(map.get(o.getId()), StockInventoryStepExecuteData.StockDetailReqVo.class));
                    SfaVisitStepStockInventoryTableDetailRespVo stockDetailNum = this.getStockDetailNum(o.getVisitStepStockList());
                    o.setStockNum(stockDetailNum.getStockNum());
                    o.setTypeNum(String.valueOf(stockDetailNum.getTypeNum()));
                    o.setSeriesNum(String.valueOf(stockDetailNum.getSeriesNum()));
                });
            }
            return PageResult.<SfaVisitStepStockInventoryTableDetailRespVo>builder()
                    .data(result)
                    .count(page.getTotal())
                    .build();
        }
        return PageResult.<SfaVisitStepStockInventoryTableDetailRespVo>builder()
                .data(Lists.newArrayList())
                .count(page.getTotal())
                .build();
    }
}
