package com.biz.crm.visitstepdetail.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.component.impl.StockInventoryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepInfoDataResp;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockInventoryReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockInventoryMapper;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockDetailEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryRedisData;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockDetailService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 拜访步骤(库存盘点);接口实现
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepStockInventoryServiceExpandImpl")
@Transactional
public class SfaVisitStepStockInventoryServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepStockInventoryMapper, SfaVisitStepStockInventoryEntity> implements ISfaVisitStepStockInventoryService, VisitDataDurabilityService {

    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    @Resource
    private SfaVisitStepStockInventoryServiceEsImpl sfaVisitStepStockInventoryServiceEsImpl;
    @Resource
    private ISfaVisitStepStockDetailService sfaVisitStepStockDetailService;
    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;


    /**
     * ########## 请务必保证接口的幂等性 ###########
     * 拜访数据持久化
     * @param baseEntity
     * @return
     */
    @Override
    @Transactional
    public  List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if(CollectionUtils.isEmpty(baseEntity)){
            return Lists.newArrayList();
        }
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)(baseEntity.get(0));
        baseEntity = Lists.newArrayList(this.save(redisData));
//        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    /**
     * 新增
     *
     * @param redisData
     * @return
     */
    @Override
    @Transactional
    public SfaVisitStepStockInventoryRedisData save(SfaVisitStepStockInventoryRedisData redisData) {
        this.saveOrUpdate(redisData);
        this.sfaVisitStepStockDetailService.remove(Wrappers.lambdaQuery(SfaVisitStepStockDetailEntity.class)
                .eq(SfaVisitStepStockDetailEntity :: getStockInventoryId, redisData.getId()));
        //竞品商品清单
        List<StockInventoryStepExecuteData.StockDetailReqVo> colletItems = redisData.getVisitStepStockList();
        if(!CollectionUtils.isEmpty(colletItems)){
            List<SfaVisitStepStockDetailEntity> itemEntities = colletItems.stream().map(v -> {
                SfaVisitStepStockDetailEntity copy = CrmBeanUtil.copy(v, SfaVisitStepStockDetailEntity.class);
                copy.setStockInventoryId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepStockDetailService.saveOrUpdateBatch(itemEntities);
        }
        return redisData;
    }

    /**
     *  推送ES
     * @param redisData
     */
    protected void doTransToEs(SfaVisitStepStockInventoryRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepStockInventoryEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepStockInventoryEsData.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        dataResp.setLastTime(this.lastTime(fromRespVo.getStepCode(), dataResp.getClientCode(), dataResp.getId()));
        if(StringUtils.isNotBlank(dataResp.getVisitPlanInfoId())){
            SfaVisitStepStockInventoryEsData oldData = this.sfaVisitStepStockInventoryEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode());
            if(null != oldData){
                dataResp.setId(oldData.getId());
            }
        }
        this.sfaVisitStepStockInventoryEsDataRepositories.save(dataResp);
    }

    /**
     * 上次盘点时间
     * @param stepCode
     * @param clientCode
     * @return
     */
    private String lastTime(String stepCode, String clientCode, String currentId){
        SfaVisitStepStockInventoryEsData esData = this.sfaVisitStepStockInventoryServiceEsImpl.getLastTimeRecord(stepCode, clientCode, LocalDateTime.now(), currentId);
        if(null == esData){
            return null;
        }
        return esData.getStockTime();
    }



    /**
     * 查看库存盘点明细信息
     * @param loadParam
     * @return
     */
    @Override
    public StockInventoryStepInfoDataResp loadInfoPage(ExecutorWorkbenchLoadReq loadParam) {
        StockInventoryStepExecuteDataResp tempData = (StockInventoryStepExecuteDataResp) stockInventoryVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        StockInventoryStepInfoDataResp dataResp = CrmBeanUtil.copy(tempData, StockInventoryStepInfoDataResp.class);
        //汇总计算
        dataResp.stockDetailGroupAndTotalNum(tempData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(tempData.getSfaVisitStepFrom());
        return dataResp;
    }









}
