package com.biz.crm.worksign.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.config.CrmDictMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 请假申请 
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Slf4j
@RestController
@RequestMapping("/sfaleave")
@Api(tags = "请假申请 ")
public class SfaLeaveController {
    @Autowired
    private ISfaLeaveService sfaLeaveService;

//    /**
//     * 列表
//     */
//    @ApiOperation(value = "查询列表")
//    @PostMapping("/list")
//    @CrmLog
//    public Result<PageResult<SfaLeaveRespVo>> list(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
//        PageResult<SfaLeaveRespVo> result=sfaLeaveService.findList(sfaLeaveReqVo);
//        return Result.ok(result);
//    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaLeaveRespVo> query(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        SfaLeaveRespVo respVo=sfaLeaveService.query(sfaLeaveReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        sfaLeaveService.save(sfaLeaveReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        sfaLeaveService.update(sfaLeaveReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody CrmIdsReqVo sfaLeaveReqVo) {
        sfaLeaveService.deleteBatch(sfaLeaveReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody CrmIdsReqVo sfaLeaveReqVo) {
        sfaLeaveService.enableBatch(sfaLeaveReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody CrmIdsReqVo sfaLeaveReqVo) {
        sfaLeaveService.disableBatch(sfaLeaveReqVo);
        return Result.ok("禁用成功");
    }
}
