package com.biz.crm.worksign.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.form.req.*;
import com.biz.crm.nebular.sfa.worksign.form.resp.*;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.req.SfaSignRecordBatchReqVo;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName SfaSignFormsController.java
 * @Description 考勤相关报表
 * @createTime 2020年11月25日 16:51:00
 */
@Slf4j
@RestController
@RequestMapping("/sfaSignFormsController")
@Api(tags = "考勤管理-报表接口 ")
public class SfaSignFormsController {

    @Autowired
    private ISfaSignFormsService service;

    @Resource
    private ISfaWorkSignRecordService sfaWorkSignRecordService;

    @ApiOperation(value = "考勤异常信息批量修改——WEB")
    @PostMapping("/updateBatchSignList")
    @CrmLog
    public Result updateBatchSignList(@RequestBody SfaSignRecordBatchReqVo sfaSignRecordBatchReqVo) {
        sfaWorkSignRecordService.updateBatchList(sfaSignRecordBatchReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "根据人员账号、职位、组织、打卡日期获取增加考勤时的相关信息——WEB")
    @PostMapping("/getSignAddRecordInfo")
    @CrmLog
    public Result<SfaSignAddRecordInfoRespVo> getSignAddRecordInfo(@RequestBody SfaSignAddRecordSearchReqVo sfaSignAddRecordSearchReqVo) {
        return Result.ok(service.getSignAddRecordInfo(sfaSignAddRecordSearchReqVo));
    }

    @ApiOperation(value = "新增考勤记录——新增打卡——WEB")
    @PostMapping("/updateSignRecord")
    @CrmLog
    public Result updateSignRecord(@RequestBody SfaSignRecordReqVo sfaSignRecordReqVo) {
        sfaWorkSignRecordService.updateSignRecord(sfaSignRecordReqVo);
        return Result.ok();
    }


    @ApiOperation(value = "获取打卡类型列表")
    @PostMapping("/getWorkSignType")
    @CrmLog
    public Result<List<Map<String, String>>> getWorkSignType() {

        return Result.ok(service.getWorkSignType());
    }

    @ApiOperation(value = "考勤明细报表")
    @PostMapping("/signDetail")
    @CrmLog
    public Result<PageResult<SfaSignDetailRespVo>> signDetail(@RequestBody SfaSignDetailReqVo reqVo) {

        return Result.ok(service.signDetail(reqVo));
    }

    @ApiOperation(value = "考勤明细报表详情——web用")
    @GetMapping("/getSignInfo")
    @CrmLog
    public Result<SfaSignDetailRespVo> getSignInfo(@RequestParam(value = "id" ,required = false) String id , @RequestParam(value = "ruleType" ,required = false) String ruleType) {
        return Result.ok(service.getSignInfo(id,ruleType));
    }




    @ApiOperation(value = "请假申请明细")
    @PostMapping("/leaveApplyDetail")
    @CrmLog
    public Result<PageResult<SfaLeaveApplyDetailRespVo>> leaveApplyDetail(@RequestBody SfaLeaveApplyDetailReqVo reqVo) {

        return Result.ok(service.leaveApplyDetail(reqVo));
    }

    @ApiOperation(value = "请假申请汇总")
    @PostMapping("/leaveApplySummary")
    @CrmLog
    public Result<PageResult<SfaLeaveApplySummaryRespVo>> leaveApplySummary(@RequestBody SfaLeaveApplySummaryReqVo reqVo) {

        return Result.ok(service.leaveApplySummary(reqVo));
    }

    @ApiOperation(value = "工作日调整申请明细")
    @PostMapping("/workOvertimeDetail")
    @CrmLog
    public Result<PageResult<SfaWorkOvertimeDetailRespVo>> workOvertimeDetail(@RequestBody SfaWorkOvertimeDetailReqVo reqVo) {

        return Result.ok(service.workOvertimeDetail(reqVo));
    }

    @ApiOperation(value = "工作日调整申请汇总")
    @PostMapping("/workOvertimeSummary")
    @CrmLog
    public Result<PageResult<SfaWorkOvertimeSummaryRespVo>> workOvertimeSummary(@RequestBody SfaWorkOvertimeSummaryReqVo reqVo) {

        return Result.ok(service.workOvertimeSummary(reqVo));
    }

    @ApiOperation(value = "异常报备申请明细")
    @PostMapping("/exceptionReportDetail")
    @CrmLog
    public Result<PageResult<SfaExceptionReportDetailRespVo>> exceptionReportDetail(@RequestBody SfaExceptionReportDetailReqVo reqVo) {

        return Result.ok(service.exceptionReportDetail(reqVo));
    }

    @ApiOperation(value = "根据审核任务id查询工作日调整明细")
    @PostMapping("/queryOvertime")
    @CrmLog
    public Result<SfaWorkOvertimeRespVo> queryOvertime(@RequestBody String id) {

        return Result.ok(service.queryOvertiem(id));
    }

    @ApiOperation(value = "出差申请明细")
    @PostMapping("/travelDetail")
    @CrmLog
    public Result<PageResult<SfaTravelRespVo>> travelDetail(@RequestBody SfaTravelReqVo reqVo) {

        return Result.ok(service.travelDetail(reqVo));
    }

    @ApiOperation(value = "根据审核任务id查询请假明细")
    @PostMapping("/queryleave")
    @CrmLog
    public Result<SfaLeaveRespVo> queryleave(@RequestBody String id) {

        return Result.ok(service.queryleave(id));
    }

    @ApiOperation(value = "根据审核任务id查询异常报备明细")
    @PostMapping("/queryException")
    @CrmLog
    public Result<SfaExceptionReportDetailRespVo> queryException(@RequestBody String id) {

        return Result.ok(service.queryException(id));
    }

    @ApiOperation(value = "根据审核任务id查询销假明细")
    @PostMapping("/queryLeaveCancel")
    @CrmLog
    public Result<SfaLeaveCancelInfoRespVo> queryLeaveCancel(@RequestBody String id) {

        return Result.ok(service.queryLeaveCancel(id));
    }

    @ApiOperation(value = "根据审核人任务id查询出差明细")
    @PostMapping("/queryTravel")
    @CrmLog
    public Result<SfaTravelRespVo> queryTravel(@RequestBody String id) {

        return Result.ok(service.queryTravel(id));
    }


    @ApiOperation(value = "个人月度考勤报表(默认当前人员,当月)")
    @PostMapping("/appUserByMonthSign")
    @CrmLog
    public Result<SfaMonthSignRespVo> appUserByMonthSign(@RequestBody SfaMonthSignReqVo reqVo) {

        return Result.ok(service.appUserByMonthSign(reqVo));
    }

    @ApiOperation(value = "月度考勤报表")
    @PostMapping("/monthSign")
    @CrmLog
    public Result<PageResult<SfaMonthSignRespVo>> monthSign(@RequestBody SfaMonthSignReqVo reqVo) {
        if(StringUtils.isEmpty(reqVo.getYearMonth())) {
            throw new BusinessException("报表年月日期不能为空");
        }

        return Result.ok(service.monthSign(reqVo));
    }

    @ApiOperation(value = "考勤报表根据时间维度统计")
    @PostMapping("/statisticsWorkSignByTimeType")
    @CrmLog
    public Result<PageResult<SfaWorkSignStatisticsRespVo>> statisticsWorkSignByTimeType(@RequestBody SfaWorkSignStatisticsReqVo reqVo) {
        if(StringUtils.isEmpty(reqVo.getYearMonthDay())) {
            throw new BusinessException("报表年月日期不能为空");
        }
        if(StringUtils.isEmpty(reqVo.getTimeType())) {
            throw new BusinessException("时间维度不能为空");
        }
        return Result.ok(service.statisticsWorkSignByTimeType(reqVo));
    }
}
