package com.biz.crm.worksign.controller;

import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 考勤规则明细表 
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksignruleinfo")
@Api(tags = "考勤规则明细表 ")
public class SfaWorkSignRuleInfoController {
    @Autowired
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSignRuleInfoRespVo>> list(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        PageResult<SfaWorkSignRuleInfoRespVo> result=sfaWorkSignRuleInfoService.findList(sfaWorkSignRuleInfoReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignRuleInfoRespVo> query(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        SfaWorkSignRuleInfoRespVo respVo=sfaWorkSignRuleInfoService.query(sfaWorkSignRuleInfoReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        sfaWorkSignRuleInfoService.save(sfaWorkSignRuleInfoReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        sfaWorkSignRuleInfoService.update(sfaWorkSignRuleInfoReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        sfaWorkSignRuleInfoService.deleteBatch(sfaWorkSignRuleInfoReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        sfaWorkSignRuleInfoService.enableBatch(sfaWorkSignRuleInfoReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
        sfaWorkSignRuleInfoService.disableBatch(sfaWorkSignRuleInfoReqVo);
        return Result.ok("禁用成功");
    }


    /**
     * 考勤明细报表列表
     */
    @ApiOperation(value = "查询考勤明细报表列表")
    @PostMapping("/findWorkSignInfoList")
    @CrmLog
    public Result<PageResult<SfaWorkSignInfoRespVo>> findWorkSignInfoList(@RequestBody SfaWorkSignInfoReqVo sfaWorkSignInfoReqVo) {
        PageResult<SfaWorkSignInfoRespVo> result=sfaWorkSignRuleInfoService.findWorkSignInfoList(sfaWorkSignInfoReqVo);
        return Result.ok(result);
    }

}
