package com.biz.crm.worksign.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.worksign.model.SfaTravelEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import java.util.List;
import java.util.Map;

/**
 * 出差申请 
 * 
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
public interface SfaTravelMapper extends BaseMapper<SfaTravelEntity> {
    /**
     * 列表
     * @param page
     * @param sfaTravelReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_travel.apply_org_code",posCode = "sfa_travel.apply_pos_code")
    List<SfaTravelRespVo> findList(Page<SfaTravelRespVo> page, @Param("vo") SfaTravelReqVo sfaTravelReqVo);


    List<SfaTravelRespVo> findDataList(@Param("vo") SfaTravelReqVo sfaTravelReqVo);

}
